/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.datagen.recipe;

import com.sammy.malum.MalumMod;
import com.sammy.malum.datagen.recipe.MalumRecipes;
import com.sammy.malum.datagen.recipe.builder.SpiritRepairRecipeBuilder;
import com.sammy.malum.registry.common.MalumSpiritTypes;
import com.sammy.malum.registry.common.item.MalumItems;
import java.util.function.Supplier;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.conditions.IConditionBuilder;

public class MalumSpiritRepairRecipes
implements IConditionBuilder {
    protected static void buildRecipes(RecipeOutput recipeOutput) {
        Criterion<InventoryChangeTrigger.TriggerInstance> has = MalumRecipes.has((ItemLike)MalumItems.REPAIR_PYLON.get());
        new SpiritRepairRecipeBuilder("wooden_.+", 0.5f, Ingredient.of((TagKey)ItemTags.PLANKS), 4).addSpirit(MalumSpiritTypes.SACRED_SPIRIT, 4).addSpirit(MalumSpiritTypes.EARTHEN_SPIRIT, 4).addItem(Items.BOW).addItem(Items.CROSSBOW).unlockedBy("has_pylon", has).save(recipeOutput, MalumMod.malumPath("wooden_restoration"));
        new SpiritRepairRecipeBuilder("flint_.+", 0.5f, Ingredient.of((ItemLike[])new ItemLike[]{Items.FLINT}), 2).addSpirit(MalumSpiritTypes.EARTHEN_SPIRIT, 4).unlockedBy("has_pylon", has).save(recipeOutput, MalumMod.malumPath("flint_restoration"));
        new SpiritRepairRecipeBuilder("stone_.+", 0.5f, Ingredient.of((TagKey)ItemTags.STONE_TOOL_MATERIALS), 2).addSpirit(MalumSpiritTypes.EARTHEN_SPIRIT, 4).unlockedBy("has_pylon", has).save(recipeOutput, MalumMod.malumPath("stone_restoration"));
        new SpiritRepairRecipeBuilder("copper_.+", 0.5f, Ingredient.of((TagKey)Tags.Items.INGOTS_COPPER), 2).addSpirit(MalumSpiritTypes.EARTHEN_SPIRIT, 6).unlockedBy("has_pylon", has).save(recipeOutput, MalumMod.malumPath("copper_restoration"));
        new SpiritRepairRecipeBuilder("iron_.+", 0.5f, Ingredient.of((TagKey)Tags.Items.INGOTS_IRON), 2).addItem((Item)MalumItems.CRUDE_SCYTHE.get()).addSpirit(MalumSpiritTypes.EARTHEN_SPIRIT, 8).unlockedBy("has_pylon", has).save(recipeOutput, MalumMod.malumPath("iron_restoration"));
        new SpiritRepairRecipeBuilder("golden_.+", 0.5f, Ingredient.of((TagKey)Tags.Items.INGOTS_GOLD), 2).addSpirit(MalumSpiritTypes.ARCANE_SPIRIT, 8).unlockedBy("has_pylon", has).save(recipeOutput, MalumMod.malumPath("gold_restoration"));
        new SpiritRepairRecipeBuilder("diamond_.+", 0.5f, Ingredient.of((TagKey)Tags.Items.GEMS_DIAMOND), 2).addSpirit(MalumSpiritTypes.ARCANE_SPIRIT, 16).addSpirit(MalumSpiritTypes.EARTHEN_SPIRIT, 16).unlockedBy("has_pylon", has).save(recipeOutput, MalumMod.malumPath("diamond_restoration"));
        new SpiritRepairRecipeBuilder("netherite_.+", 0.5f, Ingredient.of((TagKey)Tags.Items.INGOTS_NETHERITE), 1).addSpirit(MalumSpiritTypes.INFERNAL_SPIRIT, 16).addSpirit(MalumSpiritTypes.ARCANE_SPIRIT, 16).addSpirit(MalumSpiritTypes.EARTHEN_SPIRIT, 16).unlockedBy("has_pylon", has).save(recipeOutput, MalumMod.malumPath("netherite_restoration"));
        new SpiritRepairRecipeBuilder(0.5f, Ingredient.of((ItemLike[])new ItemLike[]{Items.PRISMARINE_CRYSTALS}), 8).addItem(Items.TRIDENT).addSpirit(MalumSpiritTypes.AQUEOUS_SPIRIT, 16).addSpirit(MalumSpiritTypes.ARCANE_SPIRIT, 16).unlockedBy("has_pylon", has).save(recipeOutput, MalumMod.malumPath("trident_restoration"));
        new SpiritRepairRecipeBuilder(0.5f, Ingredient.of((ItemLike[])new ItemLike[]{Items.WIND_CHARGE}), 8).addItem(Items.MACE).addSpirit(MalumSpiritTypes.AERIAL_SPIRIT, 16).addSpirit(MalumSpiritTypes.ARCANE_SPIRIT, 16).unlockedBy("has_pylon", has).save(recipeOutput, MalumMod.malumPath("mace_restoration"));
        new SpiritRepairRecipeBuilder(0.75f, Ingredient.of((ItemLike[])new ItemLike[]{Items.OBSIDIAN}), 2).addItem((Item)MalumItems.TYRVING.get()).addSpirit(MalumSpiritTypes.WICKED_SPIRIT, 16).addSpirit(MalumSpiritTypes.ARCANE_SPIRIT, 8).addSpirit(MalumSpiritTypes.EARTHEN_SPIRIT, 8).addSpirit(MalumSpiritTypes.ELDRITCH_SPIRIT, 4).unlockedBy("has_pylon", has).save(recipeOutput, MalumMod.malumPath("tyrving_restoration"));
        new SpiritRepairRecipeBuilder(0.75f, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MalumItems.SOUL_STAINED_STEEL_INGOT.get()}), 2).addItem((Item)MalumItems.SOUL_STAINED_STEEL_SCYTHE.get()).addItem((Item)MalumItems.SOUL_STAINED_STEEL_SWORD.get()).addItem((Item)MalumItems.SOUL_STAINED_STEEL_AXE.get()).addItem((Item)MalumItems.SOUL_STAINED_STEEL_PICKAXE.get()).addItem((Item)MalumItems.SOUL_STAINED_STEEL_SHOVEL.get()).addItem((Item)MalumItems.SOUL_STAINED_STEEL_HOE.get()).addItem((Item)MalumItems.SOUL_STAINED_STEEL_KNIFE.get()).addSpirit(MalumSpiritTypes.WICKED_SPIRIT, 16).addSpirit(MalumSpiritTypes.ARCANE_SPIRIT, 8).addSpirit(MalumSpiritTypes.EARTHEN_SPIRIT, 4).unlockedBy("has_pylon", has).save(recipeOutput, MalumMod.malumPath("soul_stained_steel_restoration"));
        new SpiritRepairRecipeBuilder(0.75f, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MalumItems.SOUL_STAINED_STEEL_PLATING.get()}), 3).addItem((Item)MalumItems.SOUL_STAINED_STEEL_HELMET.get()).addItem((Item)MalumItems.SOUL_STAINED_STEEL_CHESTPLATE.get()).addItem((Item)MalumItems.SOUL_STAINED_STEEL_LEGGINGS.get()).addItem((Item)MalumItems.SOUL_STAINED_STEEL_BOOTS.get()).addSpirit(MalumSpiritTypes.WICKED_SPIRIT, 16).addSpirit(MalumSpiritTypes.ARCANE_SPIRIT, 8).addSpirit(MalumSpiritTypes.EARTHEN_SPIRIT, 4).unlockedBy("has_pylon", has).save(recipeOutput, MalumMod.malumPath("soul_stained_steel_armor_restoration"));
        new SpiritRepairRecipeBuilder(0.75f, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MalumItems.SOULWOVEN_SILK.get()}), 2).addItem((Item)MalumItems.SOUL_HUNTER_CLOAK.get()).addItem((Item)MalumItems.SOUL_HUNTER_ROBE.get()).addItem((Item)MalumItems.SOUL_HUNTER_LEGGINGS.get()).addItem((Item)MalumItems.SOUL_HUNTER_BOOTS.get()).addSpirit(MalumSpiritTypes.ARCANE_SPIRIT, 8).addSpirit(MalumSpiritTypes.AERIAL_SPIRIT, 8).unlockedBy("has_pylon", has).save(recipeOutput, MalumMod.malumPath("soul_hunter_armor_restoration"));
        new SpiritRepairRecipeBuilder(0.75f, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MalumItems.MALIGNANT_LEAD.get()}), 8).addItem((Item)MalumItems.CATALYST_LOBBER.get()).addSpirit(MalumSpiritTypes.ELDRITCH_SPIRIT, 8).addSpirit(MalumSpiritTypes.INFERNAL_SPIRIT, 8).addSpirit(MalumSpiritTypes.AQUEOUS_SPIRIT, 8).unlockedBy("has_pylon", has).save(recipeOutput, MalumMod.malumPath("catalyst_lobber_restoration"));
        new SpiritRepairRecipeBuilder(0.75f, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MalumItems.MNEMONIC_FRAGMENT.get()}), 8).addItem((Item)MalumItems.MNEMONIC_HEX_STAFF.get()).addSpirit(MalumSpiritTypes.ELDRITCH_SPIRIT, 8).addSpirit(MalumSpiritTypes.AERIAL_SPIRIT, 8).addSpirit(MalumSpiritTypes.AQUEOUS_SPIRIT, 8).unlockedBy("has_pylon", has).save(recipeOutput, MalumMod.malumPath("mnemonic_hex_staff_restoration"));
        new SpiritRepairRecipeBuilder(0.75f, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MalumItems.VOID_SALTS.get()}), 8).addItem((Item)MalumItems.EROSION_SCEPTER.get()).addSpirit(MalumSpiritTypes.ELDRITCH_SPIRIT, 16).addSpirit(MalumSpiritTypes.WICKED_SPIRIT, 16).addSpirit(MalumSpiritTypes.AQUEOUS_SPIRIT, 16).unlockedBy("has_pylon", has).save(recipeOutput, MalumMod.malumPath("erosion_scepter_restoration"));
        new SpiritRepairRecipeBuilder(0.75f, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MalumItems.MALIGNANT_PEWTER_PLATING.get()}), 2).addItem((Item)MalumItems.MALIGNANT_STRONGHOLD_HELMET.get()).addItem((Item)MalumItems.MALIGNANT_STRONGHOLD_CHESTPLATE.get()).addItem((Item)MalumItems.MALIGNANT_STRONGHOLD_LEGGINGS.get()).addItem((Item)MalumItems.MALIGNANT_STRONGHOLD_BOOTS.get()).addSpirit(MalumSpiritTypes.ELDRITCH_SPIRIT, 16).addSpirit(MalumSpiritTypes.AQUEOUS_SPIRIT, 16).addSpirit(MalumSpiritTypes.EARTHEN_SPIRIT, 16).unlockedBy("has_pylon", has).save(recipeOutput, MalumMod.malumPath("malignant_stronghold_armor_restoration"));
        new SpiritRepairRecipeBuilder(0.75f, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MalumItems.MALIGNANT_PEWTER_INGOT.get()}), 1).addItem((Item)MalumItems.WEIGHT_OF_WORLDS.get()).addItem((Item)MalumItems.EDGE_OF_DELIVERANCE.get()).addSpirit(MalumSpiritTypes.ELDRITCH_SPIRIT, 16).addSpirit(MalumSpiritTypes.WICKED_SPIRIT, 16).addSpirit(MalumSpiritTypes.EARTHEN_SPIRIT, 16).unlockedBy("has_pylon", has).save(recipeOutput, MalumMod.malumPath("malignant_weapon_restoration"));
        new SpiritRepairRecipeBuilder(0.75f, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MalumItems.AURIC_EMBERS.get()}), 8).addItem((Item)MalumItems.UNWINDING_CHAOS.get()).addSpirit(MalumSpiritTypes.ELDRITCH_SPIRIT, 32).addSpirit(MalumSpiritTypes.INFERNAL_SPIRIT, 32).addSpirit(MalumSpiritTypes.AQUEOUS_SPIRIT, 32).unlockedBy("has_pylon", has).save(recipeOutput, MalumMod.malumPath("unwinding_chaos_restoration"));
        new SpiritRepairRecipeBuilder(0.75f, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MalumItems.LIVING_FLESH.get()}), 8).addItem((Item)MalumItems.SUNDERING_ANCHOR.get()).addSpirit(MalumSpiritTypes.ELDRITCH_SPIRIT, 32).addSpirit(MalumSpiritTypes.ARCANE_SPIRIT, 32).addSpirit(MalumSpiritTypes.AQUEOUS_SPIRIT, 32).unlockedBy("has_pylon", has).save(recipeOutput, MalumMod.malumPath("sundering_anchor_restoration"));
        new SpiritRepairRecipeBuilder(1.0f, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MalumItems.ALCHEMICAL_CALX.get()}), 2).addItem((Item)MalumItems.FRACTURED_ALCHEMICAL_IMPETUS.get()).addSpirit(MalumSpiritTypes.ARCANE_SPIRIT, 4).addSpirit(MalumSpiritTypes.EARTHEN_SPIRIT, 4).overrideOutput((Item)MalumItems.ALCHEMICAL_IMPETUS.get()).unlockedBy("has_pylon", has).save(recipeOutput, MalumMod.malumPath("alchemical_impetus_restoration"));
        new SpiritRepairRecipeBuilder(1.0f, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MalumItems.WIND_NUCLEUS.get()}), 4).addItem((Item)MalumItems.FRACTURED_ZEPHYR_IMPETUS.get()).addSpirit(MalumSpiritTypes.ARCANE_SPIRIT, 8).addSpirit(MalumSpiritTypes.AERIAL_SPIRIT, 8).overrideOutput((Item)MalumItems.ZEPHYR_IMPETUS.get()).unlockedBy("has_pylon", has).save(recipeOutput, MalumMod.malumPath("zephyr_impetus_restoration"));
        MalumSpiritRepairRecipes.metalImpetusRestoration(recipeOutput, MalumItems.FRACTURED_IRON_IMPETUS, MalumItems.IRON_IMPETUS);
        MalumSpiritRepairRecipes.metalImpetusRestoration(recipeOutput, MalumItems.FRACTURED_COPPER_IMPETUS, MalumItems.COPPER_IMPETUS);
        MalumSpiritRepairRecipes.metalImpetusRestoration(recipeOutput, MalumItems.FRACTURED_GOLD_IMPETUS, MalumItems.GOLD_IMPETUS);
        MalumSpiritRepairRecipes.metalImpetusRestoration(recipeOutput, MalumItems.FRACTURED_ALUMINUM_IMPETUS, MalumItems.ALUMINUM_IMPETUS);
        MalumSpiritRepairRecipes.metalImpetusRestoration(recipeOutput, MalumItems.FRACTURED_NICKEL_IMPETUS, MalumItems.NICKEL_IMPETUS);
        MalumSpiritRepairRecipes.metalImpetusRestoration(recipeOutput, MalumItems.FRACTURED_SILVER_IMPETUS, MalumItems.SILVER_IMPETUS);
        MalumSpiritRepairRecipes.metalImpetusRestoration(recipeOutput, MalumItems.FRACTURED_TIN_IMPETUS, MalumItems.TIN_IMPETUS);
        MalumSpiritRepairRecipes.metalImpetusRestoration(recipeOutput, MalumItems.FRACTURED_ZINC_IMPETUS, MalumItems.ZINC_IMPETUS);
        MalumSpiritRepairRecipes.metalImpetusRestoration(recipeOutput, MalumItems.FRACTURED_OSMIUM_IMPETUS, MalumItems.OSMIUM_IMPETUS);
        MalumSpiritRepairRecipes.metalImpetusRestoration(recipeOutput, MalumItems.FRACTURED_LEAD_IMPETUS, MalumItems.LEAD_IMPETUS);
        MalumSpiritRepairRecipes.metalImpetusRestoration(recipeOutput, MalumItems.FRACTURED_URANIUM_IMPETUS, MalumItems.URANIUM_IMPETUS);
        MalumSpiritRepairRecipes.metalImpetusRestoration(recipeOutput, MalumItems.FRACTURED_COBALT_IMPETUS, MalumItems.COBALT_IMPETUS);
    }

    public static void metalImpetusRestoration(RecipeOutput recipeOutput, Supplier<Item> crackedImpetus, Supplier<Item> impetus) {
        ResourceLocation id = crackedImpetus.get().builtInRegistryHolder().getKey().location().withSuffix("_restoration");
        Criterion<InventoryChangeTrigger.TriggerInstance> has = MalumRecipes.has((ItemLike)MalumItems.REPAIR_PYLON.get());
        new SpiritRepairRecipeBuilder(1.0f, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MalumItems.CTHONIC_GOLD_FRAGMENT.get()}), 2).addItem(crackedImpetus.get()).overrideOutput(impetus.get()).addSpirit(MalumSpiritTypes.AQUEOUS_SPIRIT, 8).addSpirit(MalumSpiritTypes.INFERNAL_SPIRIT, 8).unlockedBy("has_pylon", has).save(recipeOutput, id);
    }
}

