/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.datagen.item;

import com.sammy.malum.common.item.curiosities.curios.runes.AbstractRuneCurioItem;
import com.sammy.malum.common.item.impetus.CrackedImpetusItem;
import com.sammy.malum.common.item.impetus.ImpetusItem;
import com.sammy.malum.common.item.impetus.NodeItem;
import com.sammy.malum.common.item.spirit.SpiritShardItem;
import com.sammy.malum.datagen.item.MalumItemModelSmithTypes;
import com.sammy.malum.registry.common.item.MalumItems;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.SwordItem;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.loaders.SeparateTransformsModelBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import team.lodestar.lodestone.systems.datagen.ItemModelSmithTypes;
import team.lodestar.lodestone.systems.datagen.itemsmith.ItemModelSmith;
import team.lodestar.lodestone.systems.datagen.itemsmith.ItemModelSmithData;
import team.lodestar.lodestone.systems.datagen.itemsmith.ItemModelSmithResult;
import team.lodestar.lodestone.systems.datagen.providers.LodestoneItemModelProvider;

public class MalumItemModels
extends LodestoneItemModelProvider {
    public MalumItemModels(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "malum", existingFileHelper);
    }

    protected void registerModels() {
        HashSet<Supplier> items = new HashSet<Supplier>(MalumItems.ITEMS.getEntries());
        items.removeIf(i -> i.get() instanceof BlockItem);
        ItemModelSmithData data = new ItemModelSmithData((LodestoneItemModelProvider)this, items::remove);
        ((ItemModelSmith)ItemModelSmithTypes.PARENTED_ITEM.apply(ResourceLocation.parse((String)"item/air"))).act(data, new Supplier[]{MalumItems.SOUL_OF_A_SCYTHE, MalumItems.SOUL_OF_THE_ANCHOR}).forEach(r -> r.applyModifier(result -> {
            SeparateTransformsModelBuilder separateTransforms = result.addSeparateTransformData();
            ItemModelSmithResult guiModel = ItemModelSmithTypes.GENERATED_ITEM.addModelNameAffix("_gui").act(data, () -> ((ItemModelSmithResult)result).getItem());
            separateTransforms.perspective(ItemDisplayContext.GUI, (ModelBuilder)guiModel.parentedToThis(this.existingFileHelper));
            separateTransforms.perspective(ItemDisplayContext.FIXED, (ModelBuilder)guiModel.parentedToThis(this.existingFileHelper));
            separateTransforms.base((ModelBuilder)this.getBuilder("item/air"));
        }));
        this.setTexturePath("cosmetic/weaves/pride/");
        MalumItemModelSmithTypes.GENERATED_ITEM.act(data, new Supplier[]{MalumItems.ACE_PRIDEWEAVE, MalumItems.AGENDER_PRIDEWEAVE, MalumItems.ARO_PRIDEWEAVE, MalumItems.AROACE_PRIDEWEAVE, MalumItems.BI_PRIDEWEAVE, MalumItems.DEMIBOY_PRIDEWEAVE, MalumItems.DEMIGIRL_PRIDEWEAVE, MalumItems.ENBY_PRIDEWEAVE, MalumItems.GAY_PRIDEWEAVE, MalumItems.GENDERFLUID_PRIDEWEAVE, MalumItems.GENDERQUEER_PRIDEWEAVE, MalumItems.INTERSEX_PRIDEWEAVE, MalumItems.LESBIAN_PRIDEWEAVE, MalumItems.PAN_PRIDEWEAVE, MalumItems.PLURAL_PRIDEWEAVE, MalumItems.POLY_PRIDEWEAVE, MalumItems.PRIDE_PRIDEWEAVE, MalumItems.TRANS_PRIDEWEAVE});
        this.setTexturePath("cosmetic/weaves/");
        MalumItemModelSmithTypes.GENERATED_ITEM.act(data, new Supplier[]{MalumItems.ANCIENT_WEAVE, MalumItems.CORNERED_WEAVE, MalumItems.MECHANICAL_WEAVE_V1, MalumItems.MECHANICAL_WEAVE_V2});
        this.setTexturePath("runes/");
        MalumItemModelSmithTypes.GENERATED_ITEM.act(data, (Collection)items.stream().filter(i -> i.get() instanceof AbstractRuneCurioItem).collect(Collectors.toList()));
        this.setTexturePath("impetus/");
        MalumItemModelSmithTypes.IMPETUS_ITEM.act(data, (Collection)items.stream().filter(i -> i.get() instanceof ImpetusItem || i.get() instanceof CrackedImpetusItem).collect(Collectors.toList()));
        MalumItemModelSmithTypes.GENERATED_ITEM.act(data, (Collection)items.stream().filter(i -> i.get() instanceof NodeItem).collect(Collectors.toList()));
        this.setTexturePath("");
        MalumItemModelSmithTypes.BUILTIN_ENTITY_ITEM.act(data, MalumItems.GEAS);
        MalumItemModelSmithTypes.UMBRAL_SPIRIT_ITEM.act(data, MalumItems.UMBRAL_SPIRIT);
        MalumItemModelSmithTypes.SPIRIT_ITEM.act(data, (Collection)items.stream().filter(i -> i.get() instanceof SpiritShardItem).collect(Collectors.toList()));
        MalumItemModelSmithTypes.HANDHELD_ITEM.act(data, (Collection)items.stream().filter(i -> i.get() instanceof DiggerItem).collect(Collectors.toList()));
        MalumItemModelSmithTypes.HANDHELD_ITEM.act(data, (Collection)items.stream().filter(i -> i.get() instanceof SwordItem).collect(Collectors.toList()));
        MalumItemModelSmithTypes.HANDHELD_ITEM.act(data, new Supplier[]{MalumItems.MNEMONIC_HEX_STAFF, MalumItems.EROSION_SCEPTER});
        MalumItemModelSmithTypes.HANDHELD_OVERLAY_ITEM.act(data, new Supplier[]{MalumItems.UNWINDING_CHAOS, MalumItems.SUNDERING_ANCHOR}).forEach(result -> result.addModelLayerData().emissive(15, 15, new int[]{1}));
        MalumItemModelSmithTypes.LARGE_HANDHELD_ITEM.act(data, new Supplier[]{MalumItems.CRUDE_SCYTHE, MalumItems.SOUL_STAINED_STEEL_SCYTHE, MalumItems.EDGE_OF_DELIVERANCE, MalumItems.WEIGHT_OF_WORLDS});
        MalumItemModelSmithTypes.HANDHELD_ITEM.act(data, new Supplier[]{MalumItems.SOUL_STAINED_STEEL_KNIFE, MalumItems.TUNING_FORK, MalumItems.LAMPLIGHTERS_TONGS, MalumItems.ARTIFICERS_CLAW, MalumItems.TOTEMIC_STAFF});
        MalumItemModelSmithTypes.CATALYST_LOBBER.act(data, MalumItems.CATALYST_LOBBER);
        MalumItemModelSmithTypes.SOULWOVEN_POUCH.act(data, MalumItems.SOULWOVEN_POUCH);
        MalumItemModelSmithTypes.SKIN_APPLICABLE_ARMOR_ITEM.act(data, new Supplier[]{MalumItems.SOUL_HUNTER_CLOAK, MalumItems.SOUL_HUNTER_ROBE, MalumItems.SOUL_HUNTER_LEGGINGS, MalumItems.SOUL_HUNTER_BOOTS, MalumItems.SOUL_STAINED_STEEL_HELMET, MalumItems.SOUL_STAINED_STEEL_CHESTPLATE, MalumItems.SOUL_STAINED_STEEL_LEGGINGS, MalumItems.SOUL_STAINED_STEEL_BOOTS, MalumItems.MALIGNANT_STRONGHOLD_HELMET, MalumItems.MALIGNANT_STRONGHOLD_CHESTPLATE, MalumItems.MALIGNANT_STRONGHOLD_LEGGINGS, MalumItems.MALIGNANT_STRONGHOLD_BOOTS});
        MalumItemModelSmithTypes.GENERATED_ITEM.act(data, items);
    }

    public String getName() {
        return "Malum Item Models";
    }
}

