/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.systems.spirit;

import java.awt.Color;
import java.util.function.Function;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleDataBuilder;

public class SpiritVisualMotif {
    protected final Color primaryColor;
    protected final Color secondaryColor;
    protected final float colorCoefficient;
    protected final Easing colorEasing;
    protected final Color itemColor;
    protected final float alphaMultiplier;

    public SpiritVisualMotif(Color primaryColor, Color secondaryColor, float colorCoefficient, Easing colorEasing) {
        this(primaryColor, secondaryColor, colorCoefficient, colorEasing, primaryColor);
    }

    public SpiritVisualMotif(Color primaryColor, Color secondaryColor, float colorCoefficient, Easing colorEasing, Function<Color, Color> colorFunction) {
        this(primaryColor, secondaryColor, colorCoefficient, colorEasing, colorFunction.apply(primaryColor));
    }

    public SpiritVisualMotif(Color primaryColor, Color secondaryColor, float colorCoefficient, Easing colorEasing, Color itemColor) {
        this(primaryColor, secondaryColor, colorCoefficient, colorEasing, itemColor, 1.0f);
    }

    public SpiritVisualMotif(Color primaryColor, Color secondaryColor, float colorCoefficient, Easing colorEasing, Color itemColor, float alphaMultiplier) {
        this.primaryColor = primaryColor;
        this.secondaryColor = secondaryColor;
        this.colorCoefficient = colorCoefficient;
        this.colorEasing = colorEasing;
        this.itemColor = itemColor;
        this.alphaMultiplier = alphaMultiplier;
    }

    public ColorParticleDataBuilder createColorData() {
        return this.createColorData(1.0f);
    }

    public ColorParticleDataBuilder createColorData(float coefficientMultiplier) {
        return ColorParticleData.create((Color)this.primaryColor, (Color)this.secondaryColor).setCoefficient(this.colorCoefficient * coefficientMultiplier).setEasing(this.colorEasing);
    }

    public Color getPrimaryColor() {
        return this.primaryColor;
    }

    public float getAlphaMultiplier() {
        return this.alphaMultiplier;
    }

    public Color getSecondaryColor() {
        return this.secondaryColor;
    }

    public float getColorCoefficient() {
        return this.colorCoefficient;
    }

    public Easing getColorEasing() {
        return this.colorEasing;
    }
}

