/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.systems.rite;

import com.sammy.malum.MalumMod;
import com.sammy.malum.common.block.curiosities.totem.TotemBaseBlockEntity;
import com.sammy.malum.core.systems.rite.TotemicRiteEffect;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public abstract class TotemicRiteType {
    public static final String RITE = "malum.gui.rite";
    public static final String CORRUPTED_RITE = "malum.gui.rite.corrupt";
    public static final String TYPE = "malum.gui.rite.type";
    public static final String MEDIUM = "malum.gui.rite.medium";
    public static final String RUNEWOOD = "malum.gui.rite.medium.runewood";
    public static final String SOULWOOD = "malum.gui.rite.medium.soulwood";
    public static final String COVERAGE = "malum.gui.rite.coverage";
    public static final String EFFECT = "malum.gui.rite.effect";
    public static final String CORRUPTED_EFFECT = "malum.gui.rite.effect.corrupt";
    public final List<MalumSpiritType> spirits;
    public final String identifier;
    public final TotemicRiteEffect effect;
    public final TotemicRiteEffect corruptedEffect;

    public TotemicRiteType(String identifier, MalumSpiritType ... spirits) {
        this.identifier = identifier;
        this.spirits = new ArrayList<MalumSpiritType>(Arrays.asList(spirits));
        this.effect = this.getNaturalRiteEffect();
        this.corruptedEffect = this.getCorruptedEffect();
    }

    public List<Component> getDescription(boolean corrupted) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        UnaryOperator spiritStyleModifier = this.getIdentifyingSpirit().getItemRarity().getStyleModifier();
        TotemicRiteEffect riteEffect = this.getRiteEffect(corrupted);
        TotemicRiteEffect.MalumRiteEffectCategory riteCategory = riteEffect.category;
        tooltip.add((Component)Component.translatable((String)this.getLangKey(corrupted)).withStyle(spiritStyleModifier));
        tooltip.add(this.createDescriptionComponent(TYPE, riteCategory.getTranslationKey()));
        tooltip.add(this.createDescriptionComponent(MEDIUM, corrupted ? SOULWOOD : RUNEWOOD));
        if (!riteCategory.equals((Object)TotemicRiteEffect.MalumRiteEffectCategory.ONE_TIME_EFFECT)) {
            tooltip.add(this.createDescriptionComponent(COVERAGE, riteEffect.getRiteCoverageDescriptor()));
        }
        tooltip.add(this.createDescriptionComponent(EFFECT, (corrupted ? CORRUPTED_EFFECT : EFFECT) + "." + this.identifier));
        return tooltip;
    }

    public final Component createDescriptionComponent(String title, String type) {
        return Component.translatable((String)title).withStyle(ChatFormatting.GOLD).append((Component)Component.translatable((String)type).withStyle(ChatFormatting.YELLOW));
    }

    public String getLangKey(boolean corrupt) {
        return (corrupt ? CORRUPTED_RITE : RITE) + "." + this.identifier;
    }

    public ResourceLocation getIcon() {
        return MalumMod.malumPath("textures/vfx/rite/" + this.identifier.replace("greater_", "").replace("_rite", "") + ".png");
    }

    public MalumSpiritType getIdentifyingSpirit() {
        return this.spirits.getLast();
    }

    protected abstract TotemicRiteEffect getNaturalRiteEffect();

    protected abstract TotemicRiteEffect getCorruptedEffect();

    public final TotemicRiteEffect getRiteEffect(boolean corrupted) {
        return corrupted ? this.corruptedEffect : this.effect;
    }

    public void executeRite(TotemBaseBlockEntity totemBase) {
        this.getRiteEffect(totemBase.isSoulwood).doRiteEffect(totemBase);
    }
}

