/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.systems.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.common.recipe.MalumIngredientTypes;
import java.util.stream.Stream;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.common.crafting.IngredientType;

public class SpiritIngredient
implements ICustomIngredient {
    public static final MapCodec<SpiritIngredient> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)MalumSpiritType.CODEC.fieldOf("type").forGetter(SpiritIngredient::getSpiritType), (App)Codec.INT.fieldOf("count").forGetter(SpiritIngredient::getCount)).apply((Applicative)builder, SpiritIngredient::new));
    protected final MalumSpiritType spiritType;
    protected final int count;

    public SpiritIngredient(MalumSpiritType spiritType, int count) {
        this.spiritType = spiritType;
        this.count = count;
    }

    public MalumSpiritType getSpiritType() {
        return this.spiritType;
    }

    public int getCount() {
        return this.count;
    }

    public boolean test(ItemStack itemStack) {
        return this.spiritType.test(itemStack) && itemStack.getCount() >= this.count;
    }

    public Stream<ItemStack> getItems() {
        return Stream.of(this.getStack());
    }

    public ItemStack getStack() {
        return new ItemStack((ItemLike)this.spiritType.getSpiritShard(), this.count);
    }

    public boolean isSimple() {
        return true;
    }

    public IngredientType<?> getType() {
        return (IngredientType)MalumIngredientTypes.SPIRIT.get();
    }
}

