/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.systems.artifice;

import com.sammy.malum.core.systems.artifice.ArtificeAttributeData;
import com.sammy.malum.core.systems.artifice.ArtificeModifierSourceInstance;
import com.sammy.malum.core.systems.artifice.IArtificeAcceptor;
import com.sammy.malum.core.systems.artifice.IArtificeModifierSource;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import team.lodestar.lodestone.helpers.block.BlockEntityHelper;

public record ArtificeInfluenceData(Set<ArtificeModifierSourceInstance> modifiers) {
    public static ArtificeInfluenceData createFreshData(int lookupRange, Level level, BlockPos pos, ArtificeAttributeData attributes) {
        Collection nearbyInfluencers = BlockEntityHelper.getBlockEntities(IArtificeModifierSource.class, (Level)level, (BlockPos)pos, (int)lookupRange, ArtificeInfluenceData::isValidInfluencer);
        return ArtificeInfluenceData.createData(nearbyInfluencers, attributes);
    }

    public static ArtificeInfluenceData reconstructData(Level level, ArtificeAttributeData data) {
        HashSet<IArtificeModifierSource> nearbyInfluencers = new HashSet<IArtificeModifierSource>();
        List<BlockPos> knownPositions = data.modifierPositions;
        for (BlockPos pos : knownPositions) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof IArtificeModifierSource) {
                IArtificeModifierSource influencer = (IArtificeModifierSource)blockEntity;
                nearbyInfluencers.add(influencer);
                continue;
            }
            return null;
        }
        return ArtificeInfluenceData.createData(nearbyInfluencers, data);
    }

    public static ArtificeInfluenceData createData(Collection<IArtificeModifierSource> nearbyInfluencers, ArtificeAttributeData attributes) {
        HashSet<ArtificeModifierSourceInstance> validModifiers = new HashSet<ArtificeModifierSourceInstance>();
        HashMap<ResourceLocation, Integer> counter = new HashMap<ResourceLocation, Integer>();
        for (IArtificeModifierSource influencer : nearbyInfluencers) {
            int count;
            ArtificeModifierSourceInstance modifier = influencer.getActiveFocusingModifierInstance();
            if (!modifier.canModifyFocusing(attributes) || (count = counter.merge(modifier.type, 1, Integer::sum).intValue()) > modifier.maxAmount) continue;
            validModifiers.add(modifier);
        }
        return new ArtificeInfluenceData(validModifiers);
    }

    public static boolean isValidInfluencer(IArtificeModifierSource influencer) {
        Optional<ArtificeModifierSourceInstance> focusingModifierInstance = influencer.getFocusingModifierInstance();
        Optional<ArtificeModifierSourceInstance> artificeModifierSourceInstance = focusingModifierInstance.filter(ArtificeModifierSourceInstance::isBound);
        Optional<IArtificeAcceptor> iArtificeAcceptor = artificeModifierSourceInstance.map(p -> p.target);
        if (iArtificeAcceptor.isEmpty()) {
            return true;
        }
        IArtificeAcceptor target = iArtificeAcceptor.get();
        return !((BlockEntity)target).isRemoved();
    }
}

