/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.handlers;

import com.sammy.malum.config.CommonConfig;
import com.sammy.malum.registry.common.MalumAttributes;
import com.sammy.malum.registry.common.MalumTags;
import java.util.Optional;
import net.minecraft.world.damagesource.CombatRules;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingHealEvent;

public class MalumAttributeEventHandler {
    public static void processAttributes(LivingDamageEvent.Pre event) {
        if (event.getNewDamage() <= 0.0f) {
            return;
        }
        DamageSource source = event.getSource();
        Entity entity = source.getEntity();
        if (entity instanceof LivingEntity) {
            AttributeInstance scytheProficiency;
            LivingEntity attacker = (LivingEntity)entity;
            if (source.is(MalumTags.DamageTypeTags.IS_SCYTHE) && (scytheProficiency = attacker.getAttribute(MalumAttributes.SCYTHE_PROFICIENCY)) != null) {
                event.setNewDamage((float)((double)event.getNewDamage() * scytheProficiency.getValue()));
            }
        }
    }

    public static void heal(LivingHealEvent event) {
        if (event.getAmount() <= 0.0f) {
            return;
        }
        LivingEntity entity = event.getEntity();
        if (!entity.getAttributes().hasAttribute(MalumAttributes.HEALING_MULTIPLIER)) {
            return;
        }
        float multiplier = (float)entity.getAttributeValue(MalumAttributes.HEALING_MULTIPLIER);
        event.setAmount(event.getAmount() * multiplier);
    }

    public static Optional<Float> modifyMagicDamageArmorPiercing(LivingEntity livingEntity, DamageSource damageSource, float damageAmount) {
        if (((Boolean)CommonConfig.MAGIC_DAMAGE_REDUCED_ARMOR_PIERCING.getConfigValue()).booleanValue() && damageSource.is(MalumTags.DamageTypeTags.BYPASSES_HALF_ARMOR)) {
            float armor = (float)livingEntity.getArmorValue() * 0.5f;
            float toughness = (float)livingEntity.getAttributeValue(Attributes.ARMOR_TOUGHNESS) * 0.5f;
            float newAmount = CombatRules.getDamageAfterAbsorb((LivingEntity)livingEntity, (float)damageAmount, (DamageSource)damageSource, (float)armor, (float)toughness);
            return Optional.of(Float.valueOf(newAmount));
        }
        return Optional.empty();
    }
}

