/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.compability.jei.categories;

import com.sammy.malum.MalumMod;
import com.sammy.malum.client.screen.codex.ArcanaCodexHelper;
import com.sammy.malum.common.recipe.SpiritRepairRecipe;
import com.sammy.malum.compability.jei.JEIHandler;
import com.sammy.malum.compability.jei.JEIHelper;
import com.sammy.malum.registry.common.item.MalumItems;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class SpiritRepairRecipeCategory
implements IRecipeCategory<SpiritRepairRecipe> {
    public static final ResourceLocation UID = MalumMod.malumPath("spirit_repair");
    private final IDrawable overlay;
    private final IDrawable icon;

    public SpiritRepairRecipeCategory(IGuiHelper guiHelper) {
        this.overlay = guiHelper.createDrawable(MalumMod.malumPath("textures/gui/spirit_repair_jei.png"), 0, 0, 142, 185);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)MalumItems.REPAIR_PYLON.get()));
    }

    public void draw(SpiritRepairRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.overlay.draw(guiGraphics);
        if (!recipe.spirits.isEmpty()) {
            ArcanaCodexHelper.renderItemFrames(guiGraphics, recipe.spirits.size(), 61, 12, mouseX, mouseY, false, false);
        }
    }

    public RecipeType<SpiritRepairRecipe> getRecipeType() {
        return JEIHandler.SPIRIT_REPAIR;
    }

    public Component getTitle() {
        return Component.translatable((String)("malum.jei." + UID.getPath()));
    }

    public int getHeight() {
        return this.overlay.getHeight();
    }

    public int getWidth() {
        return this.overlay.getWidth();
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, SpiritRepairRecipe recipe, IFocusGroup focuses) {
        List<Object> repaired = recipe.itemsForRepair.stream().map(Item::getDefaultInstance).collect(Collectors.toList());
        List<ItemStack> repairIngredient = Arrays.stream(recipe.repairMaterial.getItems()).toList();
        List damaged = repaired.stream().map(ItemStack::copy).peek(s -> s.setDamageValue((int)((float)s.getMaxDamage() * recipe.durabilityPercentage))).collect(Collectors.toCollection(ArrayList::new));
        if (recipe.repairResult != Items.AIR) {
            repaired = repaired.stream().map(recipe::getResultItem).toList();
        }
        JEIHelper.addCustomIngredientToJei(builder, RecipeIngredientRole.INPUT, 61, 12, false, recipe.spirits);
        IRecipeSlotBuilder input = (IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 82, 57).addItemStacks(damaged);
        builder.addSlot(RecipeIngredientRole.INPUT, 44, 57).addItemStacks(repairIngredient);
        IRecipeSlotBuilder output = (IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 63, 124).addItemStacks(repaired);
        builder.createFocusLink(new IIngredientAcceptor[]{input, output});
    }
}

