/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.spiritrite.eldritch;

import com.sammy.malum.common.block.curiosities.totem.TotemBaseBlockEntity;
import com.sammy.malum.core.systems.rite.TotemicRiteEffect;
import com.sammy.malum.core.systems.rite.TotemicRiteType;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.MalumSpiritTypes;
import com.sammy.malum.registry.common.MalumTags;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.ServerStatsCounter;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockState;

public class EldritchAerialRiteType
extends TotemicRiteType {
    private static final List<Item> TOOLS = List.of(Items.NETHERITE_PICKAXE, Items.NETHERITE_AXE, Items.NETHERITE_SHOVEL, Items.NETHERITE_HOE);

    public EldritchAerialRiteType() {
        super("greater_aerial_rite", MalumSpiritTypes.ELDRITCH_SPIRIT, MalumSpiritTypes.ARCANE_SPIRIT, MalumSpiritTypes.AERIAL_SPIRIT, MalumSpiritTypes.AERIAL_SPIRIT);
    }

    @Override
    public TotemicRiteEffect getNaturalRiteEffect() {
        return new TotemicRiteEffect(this, TotemicRiteEffect.MalumRiteEffectCategory.DIRECTIONAL_BLOCK_EFFECT){

            @Override
            public void doRiteEffect(TotemBaseBlockEntity totemBase, ServerLevel level) {
                BlockPos pos = totemBase.getBlockPos();
                this.getBlocksAhead(totemBase).forEach(p -> {
                    BlockState state;
                    BlockState stateBelow = level.getBlockState(p.below());
                    if ((FallingBlock.isFree((BlockState)stateBelow) || !stateBelow.canOcclude() || stateBelow.is(BlockTags.SLABS)) && !(state = level.getBlockState(p)).isAir() && level.getBlockEntity(p) == null && EldritchAerialRiteType.canSilkTouch(level, pos, state)) {
                        FallingBlockEntity.fall((Level)level, (BlockPos)p, (BlockState)state);
                        MalumParticleEffectTypes.BLOCK_FALL_RITE_EFFECT.createEffect((BlockPos)p).color(MalumSpiritTypes.AERIAL_SPIRIT).spawn(level);
                        level.playSound(null, p, (SoundEvent)MalumSoundEvents.TOTEM_AERIAL_MAGIC.get(), SoundSource.BLOCKS, 0.5f, 2.6f + (level.random.nextFloat() - level.random.nextFloat()) * 0.8f);
                    }
                });
            }
        };
    }

    @Override
    public TotemicRiteEffect getCorruptedEffect() {
        return new TotemicRiteEffect(this, TotemicRiteEffect.MalumRiteEffectCategory.LIVING_ENTITY_EFFECT){

            @Override
            public void doRiteEffect(TotemBaseBlockEntity totemBase, ServerLevel level) {
                this.getNearbyEntities(totemBase, ServerPlayer.class).forEach(p -> {
                    ServerStatsCounter stats = p.getStats();
                    Stat sleepStat = Stats.CUSTOM.get((Object)Stats.TIME_SINCE_REST);
                    int value = stats.getValue(sleepStat);
                    stats.setValue((Player)p, sleepStat, Math.max(0, value - 1000));
                    MalumParticleEffectTypes.ENTITY_RITE_EFFECT.createEffect((Entity)p).color(MalumSpiritTypes.AERIAL_SPIRIT).spawn(level);
                });
            }
        };
    }

    private static ItemStack getToolForState(BlockState state) {
        if (!state.requiresCorrectToolForDrops()) {
            return new ItemStack((ItemLike)Items.NETHERITE_PICKAXE);
        }
        for (Item item : TOOLS) {
            ItemStack stack = new ItemStack((ItemLike)item);
            if (!stack.isCorrectToolForDrops(state)) continue;
            return stack;
        }
        return ItemStack.EMPTY;
    }

    private static boolean canSilkTouch(ServerLevel level, BlockPos pos, BlockState state) {
        if (state.is(MalumTags.BlockTags.GREATER_AERIAL_WHITELIST)) {
            return true;
        }
        ItemStack harvestToolStack = EldritchAerialRiteType.getToolForState(state);
        if (harvestToolStack.isEmpty()) {
            return false;
        }
        harvestToolStack.enchant(level.registryAccess().holderOrThrow(Enchantments.SILK_TOUCH), 1);
        List drops = Block.getDrops((BlockState)state, (ServerLevel)level, (BlockPos)pos, null, null, (ItemStack)harvestToolStack);
        Item blockItem = state.getBlock().asItem();
        return drops.stream().anyMatch(s -> s.getItem() == blockItem);
    }
}

