/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.spiritrite.arcane;

import com.sammy.malum.common.block.curiosities.totem.TotemBaseBlockEntity;
import com.sammy.malum.core.systems.rite.TotemicRiteEffect;
import com.sammy.malum.core.systems.rite.TotemicRiteType;
import com.sammy.malum.registry.common.MalumDamageTypes;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumSpiritTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import team.lodestar.lodestone.helpers.DamageTypeHelper;

public class WickedRiteType
extends TotemicRiteType {
    public WickedRiteType() {
        super("wicked_rite", MalumSpiritTypes.ARCANE_SPIRIT, MalumSpiritTypes.WICKED_SPIRIT, MalumSpiritTypes.WICKED_SPIRIT);
    }

    @Override
    public TotemicRiteEffect getNaturalRiteEffect() {
        return new TotemicRiteEffect(this, TotemicRiteEffect.MalumRiteEffectCategory.LIVING_ENTITY_EFFECT){

            @Override
            public void doRiteEffect(TotemBaseBlockEntity totemBase, ServerLevel level) {
                this.getNearbyEntities(totemBase, LivingEntity.class, e -> !(e instanceof Player)).forEach(e -> {
                    DamageSource damageSource = DamageTypeHelper.create((Level)e.level(), MalumDamageTypes.VOODOO_PLAYERLESS);
                    if (e.getHealth() > 2.5f && !e.isInvulnerableTo(damageSource)) {
                        MalumParticleEffectTypes.ENTITY_RITE_EFFECT.createEffect((Entity)e).color(MalumSpiritTypes.WICKED_SPIRIT).spawn(level);
                        e.hurt(damageSource, 2.0f);
                    }
                });
            }
        };
    }

    @Override
    public TotemicRiteEffect getCorruptedEffect() {
        return new TotemicRiteEffect(this, TotemicRiteEffect.MalumRiteEffectCategory.LIVING_ENTITY_EFFECT){

            @Override
            public void doRiteEffect(TotemBaseBlockEntity totemBase, ServerLevel level) {
                this.getNearbyEntities(totemBase, LivingEntity.class, e -> !(e instanceof Player)).forEach(e -> {
                    boolean hadNoEffect = !e.hasEffect(MobEffects.DAMAGE_BOOST);
                    boolean success = e.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 1200, 1));
                    if (hadNoEffect && success) {
                        MalumParticleEffectTypes.ENTITY_RITE_EFFECT.createEffect((Entity)e).color(MalumSpiritTypes.WICKED_SPIRIT).spawn(level);
                    }
                    e.addEffect(new MobEffectInstance(MobEffects.HEALTH_BOOST, 1200, 1));
                    e.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 1200, 1));
                });
            }
        };
    }
}

