/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.spiritrite.arcane;

import com.sammy.malum.common.block.curiosities.totem.TotemBaseBlockEntity;
import com.sammy.malum.common.spiritrite.PotionRiteEffect;
import com.sammy.malum.core.systems.rite.TotemicRiteEffect;
import com.sammy.malum.core.systems.rite.TotemicRiteType;
import com.sammy.malum.registry.common.MalumMobEffects;
import com.sammy.malum.registry.common.MalumSpiritTypes;
import com.sammy.malum.registry.common.MalumTags;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.state.BlockState;

public class InfernalRiteType
extends TotemicRiteType {
    public InfernalRiteType() {
        super("infernal_rite", MalumSpiritTypes.ARCANE_SPIRIT, MalumSpiritTypes.INFERNAL_SPIRIT, MalumSpiritTypes.INFERNAL_SPIRIT);
    }

    @Override
    public TotemicRiteEffect getNaturalRiteEffect() {
        return new PotionRiteEffect(MalumSpiritTypes.AERIAL_SPIRIT, LivingEntity.class, MalumMobEffects.MINERS_RAGE);
    }

    @Override
    public TotemicRiteEffect getCorruptedEffect() {
        return new PotionRiteEffect(this, MalumSpiritTypes.AERIAL_SPIRIT, LivingEntity.class, MalumMobEffects.IFRITS_EMBRACE){

            @Override
            public void doRiteEffect(TotemBaseBlockEntity totemBase, ServerLevel level) {
                super.doRiteEffect(totemBase, level);
                this.getNearbyBlocks(totemBase, BaseFireBlock.class).forEach(p -> {
                    BlockState state = totemBase.getLevel().getBlockState(p);
                    if (!state.is(MalumTags.BlockTags.INEXTINGUISHABLE_FLAME)) {
                        level.playSound(null, p, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 1.0f, 2.6f + (level.random.nextFloat() - level.random.nextFloat()) * 0.8f);
                        totemBase.getLevel().removeBlock(p, false);
                    }
                });
            }

            @Override
            public Predicate<LivingEntity> getEntityPredicate() {
                return super.getEntityPredicate().and(Entity::isOnFire);
            }
        };
    }
}

