/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.spiritrite.arcane;

import com.sammy.malum.common.block.curiosities.totem.TotemBaseBlockEntity;
import com.sammy.malum.common.recipe.SpiritTransmutationRecipe;
import com.sammy.malum.common.worldevent.UnchainedTotemConversionWorldEvent;
import com.sammy.malum.core.systems.rite.TotemicRiteEffect;
import com.sammy.malum.core.systems.rite.TotemicRiteType;
import com.sammy.malum.registry.common.MalumSpiritTypes;
import com.sammy.malum.registry.common.MalumTags;
import com.sammy.malum.registry.common.recipe.MalumRecipeTypes;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import team.lodestar.lodestone.handlers.WorldEventHandler;
import team.lodestar.lodestone.helpers.block.BlockStateHelper;
import team.lodestar.lodestone.systems.recipe.LodestoneRecipeType;
import team.lodestar.lodestone.systems.worldevent.WorldEventInstance;

public class ArcaneRiteType
extends TotemicRiteType {
    public ArcaneRiteType() {
        super("arcane_rite", MalumSpiritTypes.ARCANE_SPIRIT, MalumSpiritTypes.ARCANE_SPIRIT, MalumSpiritTypes.ARCANE_SPIRIT, MalumSpiritTypes.ARCANE_SPIRIT, MalumSpiritTypes.ARCANE_SPIRIT);
    }

    @Override
    public TotemicRiteEffect getNaturalRiteEffect() {
        return new TotemicRiteEffect(this, TotemicRiteEffect.MalumRiteEffectCategory.ONE_TIME_EFFECT){

            @Override
            public void doRiteEffect(TotemBaseBlockEntity totemBase, ServerLevel level) {
                WorldEventHandler.addWorldEvent((Level)totemBase.getLevel(), (WorldEventInstance)new UnchainedTotemConversionWorldEvent().setPosition(totemBase.getBlockPos()).setData(List.of(Integer.valueOf(1), Integer.valueOf(3), Integer.valueOf(5), Integer.valueOf(6), Integer.valueOf(7), Integer.valueOf(8)), 4, 0));
            }
        };
    }

    @Override
    public TotemicRiteEffect getCorruptedEffect() {
        return new TotemicRiteEffect(this, TotemicRiteEffect.MalumRiteEffectCategory.RADIAL_BLOCK_EFFECT){

            @Override
            public boolean canAffectBlock(TotemBaseBlockEntity totemBase, BlockState state, BlockPos pos) {
                return state.is(MalumTags.BlockTags.UNCHAINED_RITE_CATALYST) && super.canAffectBlock(totemBase, state, pos);
            }

            @Override
            public void doRiteEffect(TotemBaseBlockEntity totemBase, ServerLevel level) {
                BlockPos pos = totemBase.getBlockPos();
                List<BlockPos> nearbyBlocks = this.getNearbyBlocks(totemBase, Block.class).toList();
                for (BlockPos p : nearbyBlocks) {
                    BlockEntity newEntity;
                    Item item;
                    BlockPos targetPos = p.above();
                    BlockState targetState = level.getBlockState(targetPos);
                    ItemStack targetAsItem = targetState.getBlock().asItem().getDefaultInstance();
                    SpiritTransmutationRecipe recipe = (SpiritTransmutationRecipe)LodestoneRecipeType.getRecipe((Level)level, (RecipeType)((RecipeType)MalumRecipeTypes.SPIRIT_TRANSMUTATION.get()), (RecipeInput)new SingleRecipeInput(targetAsItem));
                    if (recipe == null || !((item = recipe.output.getItem()) instanceof BlockItem)) continue;
                    BlockItem blockItem = (BlockItem)item;
                    Block resultBlock = blockItem.getBlock();
                    BlockState newState = BlockStateHelper.setBlockStateWithExistingProperties((Level)level, (BlockPos)targetPos, (BlockState)resultBlock.defaultBlockState(), (int)3);
                    level.levelEvent(2001, targetPos, Block.getId((BlockState)newState));
                    if (!(resultBlock instanceof EntityBlock)) continue;
                    EntityBlock entityBlock = (EntityBlock)resultBlock;
                    BlockEntity entity = level.getBlockEntity(targetPos);
                    if (entity == null || (newEntity = entityBlock.newBlockEntity(pos, newState)) == null || !newEntity.getClass().equals(entity.getClass())) continue;
                    level.setBlockEntity(entity);
                }
            }
        };
    }
}

