/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.ether;

import com.sammy.malum.common.item.ether.EtherItem;
import java.awt.Color;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import team.lodestar.lodestone.registry.common.particle.LodestoneScreenParticleTypes;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.builder.ScreenParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleDataBuilder;
import team.lodestar.lodestone.systems.particle.screen.ScreenParticleHolder;
import team.lodestar.lodestone.systems.particle.screen.ScreenParticleType;

public class EtherBrazierItem
extends EtherItem {
    public EtherBrazierItem(Block blockIn, Item.Properties builder, boolean iridescent) {
        super(blockIn, builder, iridescent);
    }

    @Override
    public void spawnLateParticles(ScreenParticleHolder target, Level level, float partialTick, ItemStack stack, float x, float y) {
        Color firstColor = new Color(EtherItem.getPrimaryColor(stack));
        Color secondColor = new Color(EtherItem.getSecondaryColor(stack));
        float alphaMultiplier = this.isIridescent ? 0.75f : 0.5f;
        float time = (float)level.getGameTime() + partialTick;
        SpinParticleDataBuilder spinDataBuilder = SpinParticleData.create((float)0.0f, (float)1.0f).setSpinOffset(0.025f * time % 6.28f).setEasing(Easing.EXPO_IN_OUT);
        ScreenParticleBuilder.create((ScreenParticleType)LodestoneScreenParticleTypes.STAR, (ScreenParticleHolder)target).setTransparencyData(GenericParticleData.create((float)(0.06f * alphaMultiplier), (float)0.0f).setEasing(Easing.QUINTIC_IN).build()).setScaleData(GenericParticleData.create((float)((float)((double)1.3f + Math.sin(time * 0.1f) * 0.125)), (float)0.0f).build()).setColorData(ColorParticleData.create((Color)firstColor, (Color)secondColor).setCoefficient(1.25f).build()).setLifetime(6).setRandomOffset((double)0.05f).setSpinData(spinDataBuilder.build()).spawnOnStack(-0.5, -2.0).setScaleData(GenericParticleData.create((float)((float)((double)1.2f - Math.sin(time * 0.075f) * 0.125)), (float)0.0f).build()).setColorData(ColorParticleData.create((Color)secondColor, (Color)firstColor).build()).setSpinData(spinDataBuilder.setSpinOffset(0.785f - 0.01f * time % 6.28f).build()).spawnOnStack(-0.5, -2.0);
    }
}

