/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.curiosities.weapons;

import com.sammy.malum.common.item.curiosities.weapons.scythe.EdgeOfDeliveranceItem;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.registry.common.MalumDamageTypes;
import com.sammy.malum.registry.common.MalumMobEffects;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.MalumTags;
import com.sammy.malum.visual_effects.networked.MalumNetworkedWeaponParticleEffectType;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.client.event.AddAttributeTooltipsEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import team.lodestar.lodestone.handlers.ItemEventHandler;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.helpers.SoundHelper;
import team.lodestar.lodestone.registry.common.tag.LodestoneDamageTypeTags;
import team.lodestar.lodestone.systems.item.LodestoneItemProperties;
import team.lodestar.lodestone.systems.item.tools.LodestoneAxeItem;
import team.lodestar.lodestone.systems.network.WeaponParticleEffectType;

public class WeightOfWorldsItem
extends LodestoneAxeItem
implements ItemEventHandler.IEventResponder {
    public WeightOfWorldsItem(Tier tier, float attackDamage, float attackSpeed, LodestoneItemProperties properties) {
        super(tier, attackDamage, attackSpeed, properties);
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        if (enchantment.equals((Object)Enchantments.BREACH)) {
            return true;
        }
        return super.supportsEnchantment(stack, enchantment);
    }

    public void modifyAttributeTooltipEvent(AddAttributeTooltipsEvent event) {
        event.addTooltipLines(new Component[]{ComponentHelper.positiveEffect("weight_of_worlds_crit", new Object[0])});
        event.addTooltipLines(new Component[]{ComponentHelper.positiveEffect("weight_of_worlds_kill", new Object[0])});
    }

    public void outgoingDeathEvent(LivingDeathEvent event, LivingEntity attacker, LivingEntity target, ItemStack stack) {
        attacker.addEffect(new MobEffectInstance(MalumMobEffects.GRIM_CERTAINTY, 200));
    }

    public void outgoingDamageEvent(LivingDamageEvent.Pre event, LivingEntity attacker, LivingEntity target, ItemStack stack) {
        Level level = attacker.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            DamageSource source = event.getSource();
            if (source.is(LodestoneDamageTypeTags.CAN_TRIGGER_MAGIC) || source.is(MalumDamageTypes.INVERTED_HEART_PROPAGATION)) {
                MalumNetworkedWeaponParticleEffectType particleEffectType = MalumParticleEffectTypes.SCYTHE_SLASH;
                DeferredHolder<MobEffect, MobEffect> effectType = MalumMobEffects.GRIM_CERTAINTY;
                if (attacker.hasEffect(effectType) || level2.random.nextFloat() < 0.25f) {
                    if (EdgeOfDeliveranceItem.triggerMalignantCrit(event.getContainer(), attacker, target)) {
                        particleEffectType = MalumParticleEffectTypes.WEIGHT_OF_WORLDS_CRIT;
                        attacker.removeEffect(effectType);
                    }
                } else if (!source.is(LodestoneDamageTypeTags.CAN_TRIGGER_MAGIC)) {
                    return;
                }
                WeaponParticleEffectType.WeaponParticleEffectBuilder effectBuilder = particleEffectType.createEffect().originatesFrom((Entity)attacker).targets((Entity)target).verticalSlashRotation().horizontalOffset(0.4f).forwardOffset(0.8f);
                if (source.is(MalumTags.DamageTypeTags.IS_INVERTED_HEART)) {
                    effectBuilder.tiedToTarget().horizontalOffset(0.2f).horizontalDeviation(RandomHelper.randomBetween((RandomSource)attacker.getRandom(), (float)-0.5f, (float)0.5f)).forwardOffset(-0.8f);
                }
                effectBuilder.spawn(level2);
                SoundHelper.playSound((Entity)target, (SoundEvent)((SoundEvent)MalumSoundEvents.WEIGHT_OF_WORLDS_CUT.get()), (SoundSource)SoundSource.PLAYERS, (float)2.0f, (float)0.75f);
            }
        }
    }
}

