/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.curiosities.curios.sets.weeping;

import com.sammy.malum.common.data.attachment.CurioData;
import com.sammy.malum.common.entity.activator.SpiritCollectionActivatorEntityOld;
import com.sammy.malum.common.item.IMalumEventResponder;
import com.sammy.malum.common.item.IVoidItem;
import com.sammy.malum.common.item.curiosities.curios.AbstractMalumCurioItem;
import com.sammy.malum.common.item.curiosities.curios.MalumCurioItem;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.registry.common.MalumAttachmentTypes;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import team.lodestar.lodestone.helpers.RandomHelper;

public class CurioWatcherNecklace
extends MalumCurioItem
implements IMalumEventResponder,
IVoidItem {
    public CurioWatcherNecklace(Item.Properties builder) {
        super(builder, AbstractMalumCurioItem.MalumTrinketType.VOID);
    }

    @Override
    public void addExtraTooltipLines(Consumer<Component> consumer) {
        consumer.accept(ComponentHelper.positiveCurioEffect("full_health_fake_collection", new Object[0]));
    }

    public void outgoingDamageEvent(LivingDamageEvent.Pre event, LivingEntity attacker, LivingEntity target, ItemStack stack) {
        if (target.getHealth() >= target.getMaxHealth() * 0.9875f) {
            CurioData data = (CurioData)target.getData(MalumAttachmentTypes.CURIO_DATA);
            if (data.watcherNecklaceCooldown == 0) {
                float speed = 0.4f;
                Level level = attacker.level();
                RandomSource random = level.getRandom();
                Vec3 position = target.position().add(0.0, (double)(target.getBbHeight() / 2.0f), 0.0);
                int amount = target instanceof Player ? 2 : 1;
                for (int i = 0; i < amount; ++i) {
                    SpiritCollectionActivatorEntityOld entity = new SpiritCollectionActivatorEntityOld(level, attacker.getUUID(), position.x, position.y, position.z, RandomHelper.randomBetween((RandomSource)random, (float)(-speed), (float)speed), RandomHelper.randomBetween((RandomSource)random, (float)0.05f, (float)0.06f), RandomHelper.randomBetween((RandomSource)random, (float)(-speed), (float)speed));
                    level.addFreshEntity((Entity)entity);
                }
                data.watcherNecklaceCooldown = 400;
            }
        }
    }

    public static void entityTick(EntityTickEvent.Pre event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            CurioData data = (CurioData)entity2.getData(MalumAttachmentTypes.CURIO_DATA);
            if (data.watcherNecklaceCooldown > 0) {
                --data.watcherNecklaceCooldown;
            }
        }
    }
}

