/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.curiosities.curios.sets.misc;

import com.sammy.malum.common.item.curiosities.curios.AbstractMalumCurioItem;
import com.sammy.malum.common.item.curiosities.curios.MalumCurioItem;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.core.systems.spirit.EntitySpiritDropData;
import com.sammy.malum.registry.common.item.MalumItems;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.event.entity.living.LivingEvent;
import team.lodestar.lodestone.helpers.CurioHelper;

public class CurioHarmonyNecklace
extends MalumCurioItem {
    public CurioHarmonyNecklace(Item.Properties builder) {
        super(builder, AbstractMalumCurioItem.MalumTrinketType.METALLIC);
    }

    @Override
    public void addExtraTooltipLines(Consumer<Component> consumer) {
        consumer.accept(ComponentHelper.positiveCurioEffect("friendly_enemies", new Object[0]));
    }

    public static void preventDetection(LivingEvent.LivingVisibilityEvent event) {
        Entity entity = event.getLookingEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity watcher = (LivingEntity)entity;
            LivingEntity target = event.getEntity();
            if (CurioHelper.hasCurioEquipped((LivingEntity)target, (Item)((Item)MalumItems.NECKLACE_OF_BLISSFUL_HARMONY.get()))) {
                float visibilityModifier = EntitySpiritDropData.getSpiritData(watcher).map(data -> Float.valueOf(0.5f / (float)(1L + (long)data.getSpirits().size()))).orElse(Float.valueOf(0.5f)).floatValue();
                if (target.hasEffect(MobEffects.INVISIBILITY)) {
                    visibilityModifier *= 0.5f;
                }
                event.modifyVisibility((double)visibilityModifier);
            }
        }
    }
}

