/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.curiosities;

import com.sammy.malum.common.data.component.CatalystFlingerStateComponent;
import com.sammy.malum.common.entity.nitrate.AbstractNitrateEntity;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.item.MalumDataComponents;
import com.sammy.malum.registry.common.item.MalumItems;
import java.util.function.Function;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class CatalystLobberItem
extends Item {
    public final Function<Player, AbstractNitrateEntity> entitySupplier;

    public CatalystLobberItem(Item.Properties pProperties, Function<Player, AbstractNitrateEntity> entitySupplier) {
        super(pProperties);
        this.entitySupplier = entitySupplier;
    }

    public static int getStateDisplay(ItemStack stack) {
        CatalystFlingerStateComponent data = (CatalystFlingerStateComponent)stack.get(MalumDataComponents.CATALYST_LOBBER_STATE);
        if (data == null) {
            return -1;
        }
        return data.state();
    }

    public boolean isValidRepairItem(ItemStack stack, ItemStack repairCandidate) {
        return repairCandidate.getItem().equals(MalumItems.MALIGNANT_LEAD.get()) || super.isValidRepairItem(stack, repairCandidate);
    }

    public void inventoryTick(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        int state;
        CatalystFlingerStateComponent data = (CatalystFlingerStateComponent)pStack.get(MalumDataComponents.CATALYST_LOBBER_STATE);
        if (data != null && (state = data.state()) != 0) {
            int timer = data.timer();
            int stashedState = data.stashedState();
            if (!pIsSelected) {
                ++timer;
            } else if (timer > 0) {
                timer = 0;
            }
            if (timer >= 100) {
                timer = 0;
                stashedState = state;
                state = 0;
                pEntity.playSound((SoundEvent)MalumSoundEvents.CATALYST_LOBBER_LOCKED.get(), 1.2f, 0.8f);
            }
            pStack.set(MalumDataComponents.CATALYST_LOBBER_STATE, (Object)new CatalystFlingerStateComponent(timer, state, stashedState));
        }
        super.inventoryTick(pStack, pLevel, pEntity, pSlotId, pIsSelected);
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        SoundEvent sound;
        ItemStack stack = playerIn.getItemInHand(handIn);
        CatalystFlingerStateComponent component = (CatalystFlingerStateComponent)stack.getOrDefault(MalumDataComponents.CATALYST_LOBBER_STATE, (Object)new CatalystFlingerStateComponent());
        int timer = component.timer();
        int state = component.state();
        int stashedState = component.stashedState();
        int cooldown = 0;
        switch (state) {
            case 0: {
                cooldown = 100;
                state = Math.max(1, stashedState);
                sound = (SoundEvent)MalumSoundEvents.CATALYST_LOBBER_UNLOCKED.get();
                break;
            }
            case 1: {
                if (!playerIn.isCreative()) {
                    ItemStack ammo = ItemStack.EMPTY;
                    for (int i = 0; i < playerIn.getInventory().getContainerSize(); ++i) {
                        ItemStack maybeAmmo = playerIn.getInventory().getItem(i);
                        if (!maybeAmmo.getItem().equals(MalumItems.AURIC_EMBERS.get())) continue;
                        ammo = maybeAmmo;
                        break;
                    }
                    if (ammo.isEmpty()) {
                        return InteractionResultHolder.fail((Object)stack);
                    }
                    ammo.shrink(1);
                }
                cooldown = 20;
                state = 2;
                sound = (SoundEvent)MalumSoundEvents.CATALYST_LOBBER_PRIMED.get();
                break;
            }
            case 2: {
                if (!worldIn.isClientSide) {
                    AbstractNitrateEntity bombEntity = this.entitySupplier.apply(playerIn);
                    int angle = handIn == InteractionHand.MAIN_HAND ? 225 : 90;
                    Vec3 pos = playerIn.position().add(playerIn.getLookAngle().scale(0.5)).add(0.5 * Math.sin(Math.toRadians((float)angle - playerIn.yHeadRot)), (double)(playerIn.getBbHeight() * 2.0f / 3.0f), 0.5 * Math.cos(Math.toRadians((float)angle - playerIn.yHeadRot)));
                    float pitch = -10.0f;
                    bombEntity.shootFromRotation((Entity)playerIn, playerIn.getXRot(), playerIn.getYRot(), pitch, 1.25f, 0.9f);
                    bombEntity.setPos(pos);
                    worldIn.addFreshEntity((Entity)bombEntity);
                }
                playerIn.awardStat(Stats.ITEM_USED.get((Object)this));
                if (!playerIn.getAbilities().instabuild) {
                    stack.hurtAndBreak(1, (LivingEntity)playerIn, EquipmentSlot.MAINHAND);
                }
                state = 1;
                sound = (SoundEvent)MalumSoundEvents.CATALYST_LOBBER_FIRED.get();
                break;
            }
            default: {
                stack.set(MalumDataComponents.CATALYST_LOBBER_STATE, (Object)new CatalystFlingerStateComponent());
                throw new IllegalStateException("Catalyst lobber used with an invalid state.");
            }
        }
        stack.set(MalumDataComponents.CATALYST_LOBBER_STATE, (Object)new CatalystFlingerStateComponent(timer, state, stashedState));
        if (cooldown != 0) {
            playerIn.getCooldowns().addCooldown((Item)this, cooldown);
        }
        playerIn.playSound(sound, 1.0f, 1.0f);
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)worldIn.isClientSide());
    }
}

