/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.banner;

import com.sammy.malum.common.data.component.SoulwovenBannerPatternDataComponent;
import com.sammy.malum.registry.common.block.MalumBlocks;
import com.sammy.malum.registry.common.item.MalumDataComponents;
import com.sammy.malum.registry.common.item.MalumItems;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;

public class SoulwovenBannerBlockItem
extends BlockItem {
    public SoulwovenBannerBlockItem(Item.Properties properties) {
        super((Block)MalumBlocks.SOULWOVEN_BANNER.get(), properties.component(MalumDataComponents.SOULWOVEN_BANNER_PATTERN, (Object)SoulwovenBannerPatternDataComponent.DEFAULT));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        SoulwovenBannerPatternDataComponent pattern = (SoulwovenBannerPatternDataComponent)stack.get(MalumDataComponents.SOULWOVEN_BANNER_PATTERN);
        if (pattern != null && !pattern.equals(SoulwovenBannerPatternDataComponent.DEFAULT)) {
            tooltipComponents.add((Component)Component.translatable((String)pattern.translationKey()).withStyle(ChatFormatting.GRAY));
        }
    }

    public static float getBannerPattern(ItemStack stack) {
        SoulwovenBannerPatternDataComponent pattern = (SoulwovenBannerPatternDataComponent)stack.getOrDefault(MalumDataComponents.SOULWOVEN_BANNER_PATTERN, (Object)SoulwovenBannerPatternDataComponent.DEFAULT);
        return SoulwovenBannerPatternDataComponent.REGISTERED_PATTERNS.contains(pattern) ? (float)SoulwovenBannerPatternDataComponent.REGISTERED_PATTERNS.indexOf(pattern) : 0.0f;
    }

    public static void addBannerVariantsToCreativeTab(BuildCreativeModeTabContentsEvent event) {
        ItemStack defaultInstance = ((Item)MalumItems.SOULWOVEN_BANNER.get()).getDefaultInstance();
        if (event.getParentEntries().contains((Object)defaultInstance)) {
            for (SoulwovenBannerPatternDataComponent pattern : SoulwovenBannerPatternDataComponent.REGISTERED_PATTERNS) {
                if (pattern.equals(SoulwovenBannerPatternDataComponent.DEFAULT)) continue;
                ItemStack copy = pattern.getDefaultStack();
                if (event.getParentEntries().contains((Object)copy)) continue;
                event.insertAfter(defaultInstance, copy, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            }
        }
    }
}

