/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.augment.core;

import com.sammy.malum.common.item.augment.core.CoreAugmentItem;
import com.sammy.malum.core.systems.artifice.ArtificeAttributeData;
import com.sammy.malum.core.systems.artifice.ArtificeAttributeType;
import com.sammy.malum.core.systems.artifice.ArtificeModifier;
import com.sammy.malum.registry.common.MalumSpiritTypes;
import java.util.List;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class SympathyDrive
extends CoreAugmentItem {
    public SympathyDrive(Item.Properties pProperties) {
        super(pProperties, List.of(MalumSpiritTypes.SACRED_SPIRIT, MalumSpiritTypes.WICKED_SPIRIT), true, new ArtificeModifier(ArtificeAttributeType.MISFORTUNE_REVERSAL, 1.0f));
    }

    public static void completeCycle(ArtificeAttributeData attributes, int durabilityCost) {
        float misfortuneReversal = attributes.misfortuneReversal.getValue(attributes);
        if (misfortuneReversal > 0.0f) {
            attributes.sympathyDamageStacks += durabilityCost;
        }
        if (attributes.sympathyBuffedCycles > 0) {
            --attributes.sympathyBuffedCycles;
        }
    }

    public static void repairImpetus(Level level, ArtificeAttributeData attributes, ItemStack impetus) {
        float misfortuneReversal = attributes.misfortuneReversal.getValue(attributes);
        float repairPercentage = 0.01f * misfortuneReversal;
        float buffStrength = 0.2f + (float)attributes.sympathyDamageStacks * 0.05f;
        int repairedAmount = Mth.ceil((float)((float)impetus.getMaxDamage() * repairPercentage));
        impetus.setDamageValue(Math.max(impetus.getDamageValue() - repairedAmount, 0));
        attributes.sympathyDamageStacks = 0;
        attributes.sympathyBuffedCycles = 3;
        attributes.sympathyBuffStrength = buffStrength;
    }
}

