/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.geas.pact.earthen;

import com.sammy.malum.common.worldevent.DelayedDamageWorldEvent;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.core.systems.events.ModifyGluttonyPropertiesEvent;
import com.sammy.malum.core.systems.geas.GeasEffect;
import com.sammy.malum.core.systems.geas.GeasEffectType;
import com.sammy.malum.registry.common.MalumDamageTypes;
import com.sammy.malum.registry.common.MalumGeasEffectTypes;
import com.sammy.malum.registry.common.MalumMobEffects;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.MalumSpiritTypes;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectColorData;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import team.lodestar.lodestone.handlers.WorldEventHandler;
import team.lodestar.lodestone.helpers.EntityHelper;
import team.lodestar.lodestone.systems.worldevent.WorldEventInstance;

public class ProfaneGluttonGeas
extends GeasEffect {
    public ProfaneGluttonGeas() {
        super((GeasEffectType)MalumGeasEffectTypes.PACT_OF_THE_PROFANE_GLUTTON.get());
    }

    @Override
    public void modifyGluttonyPropertiesEvent(ModifyGluttonyPropertiesEvent event, LivingEntity collector) {
        event.getProperties().scaleInitialAmplifier(2.0f).scaleAmplifierGain(2.0f).scaleAmplifierLimit(4.0f).replaceEffectType((Holder<MobEffect>)MalumMobEffects.DESPERATE_NEED);
    }

    @Override
    public void addTooltipComponents(LivingEntity entity, Consumer<Component> tooltipAcceptor, TooltipFlag tooltipFlag) {
        tooltipAcceptor.accept(ComponentHelper.positiveGeasEffect("desperate_need", new Object[0]));
        tooltipAcceptor.accept(ComponentHelper.positiveGeasEffect("desperate_need_scythe_proficiency", new Object[0]));
        tooltipAcceptor.accept(ComponentHelper.negativeGeasEffect("desperate_need_betrayal", new Object[0]));
        super.addTooltipComponents(entity, tooltipAcceptor, tooltipFlag);
    }

    public void incomingDamageEvent(LivingDamageEvent.Pre event, LivingEntity attacker, LivingEntity target, ItemStack stack) {
        MobEffectInstance effect = target.getEffect(MalumMobEffects.DESPERATE_NEED);
        if (effect != null) {
            EntityHelper.shortenEffect((MobEffectInstance)effect, (LivingEntity)target, (int)(effect.getDuration() / 4));
            if (event.getSource().is(MalumDamageTypes.ROT)) {
                target.addEffect(new MobEffectInstance(MobEffects.POISON, 40, 0, true, true));
                return;
            }
            RandomSource random = target.getRandom();
            for (float chance = (float)effect.getAmplifier() * 0.02f; chance > 0.0f; chance -= 1.0f) {
                if (!(random.nextFloat() < chance)) continue;
                WorldEventHandler.addWorldEvent((Level)target.level(), (WorldEventInstance)new DelayedDamageWorldEvent((Entity)target).setDamageData(1.0f, 1.0f, 2).setPhysicalDamageType(MalumDamageTypes.ROT).setMagicDamageType(MalumDamageTypes.ROT).setImpactParticleEffect(MalumParticleEffectTypes.SHAKEN_FAITH, new MalumNetworkedParticleEffectColorData(MalumSpiritTypes.EARTHEN_SPIRIT)).setSound((Holder<SoundEvent>)MalumSoundEvents.DESPERATE_NEED_WITHDRAWAL, 0.5f, 1.5f, 0.3f));
            }
        }
    }
}

