/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.geas.pact.aerial;

import com.google.common.collect.Multimap;
import com.sammy.malum.core.handlers.GeasEffectHandler;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.core.systems.geas.GeasEffect;
import com.sammy.malum.core.systems.geas.GeasEffectType;
import com.sammy.malum.registry.common.MalumGeasEffectTypes;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.neoforge.event.entity.living.LivingKnockBackEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

public class WindsweptGeas
extends GeasEffect {
    public static final int MAX_SPRINT_STACKS = 50;
    public int sprintStacks;

    public WindsweptGeas() {
        super((GeasEffectType)MalumGeasEffectTypes.PACT_OF_THE_WINDSWEPT.get());
    }

    @Override
    public Multimap<Holder<Attribute>, AttributeModifier> createAttributeModifiers(LivingEntity entity, Multimap<Holder<Attribute>, AttributeModifier> modifiers) {
        if (this.sprintStacks > 0) {
            this.addAttributeModifier(modifiers, (Holder<Attribute>)Attributes.MOVEMENT_SPEED, 0.01f * (float)this.sprintStacks, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        }
        return modifiers;
    }

    @Override
    public void addTooltipComponents(LivingEntity entity, Consumer<Component> tooltipAcceptor, TooltipFlag tooltipFlag) {
        super.addTooltipComponents(entity, tooltipAcceptor, tooltipFlag);
        tooltipAcceptor.accept(ComponentHelper.positiveGeasEffect("movement_acceleration", new Object[0]));
        tooltipAcceptor.accept(ComponentHelper.negativeGeasEffect("knockback_also_accelerates", new Object[0]));
    }

    public static void scaleKnockback(LivingKnockBackEvent event) {
        LivingEntity entity = event.getEntity();
        GeasEffect geas = GeasEffectHandler.getGeasEffect(entity, MalumGeasEffectTypes.PACT_OF_THE_WINDSWEPT);
        if (geas instanceof WindsweptGeas) {
            WindsweptGeas windsweptGeas = (WindsweptGeas)geas;
            if (windsweptGeas.sprintStacks > 0) {
                float knockbackStrength = (float)Math.max(0, windsweptGeas.sprintStacks - 10) * 0.1f;
                event.setStrength(event.getStrength() * (1.0f + knockbackStrength));
            }
        }
    }

    @Override
    public void update(EntityTickEvent.Pre event, LivingEntity entity) {
        if (entity.level().getGameTime() % 10L == 0L) {
            if (entity.isSprinting()) {
                if (this.sprintStacks < 50) {
                    ++this.sprintStacks;
                }
            } else if (this.sprintStacks > 0) {
                this.sprintStacks = Math.max(0, this.sprintStacks - 5);
            }
            this.setDirty();
        }
    }
}

