/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.geas.pact.aerial;

import com.google.common.collect.Multimap;
import com.sammy.malum.core.handlers.GeasEffectHandler;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.core.systems.geas.GeasEffect;
import com.sammy.malum.core.systems.geas.GeasEffectType;
import com.sammy.malum.registry.common.MalumGeasEffectTypes;
import com.sammy.malum.registry.common.MalumMobEffects;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.level.ExplosionKnockbackEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

public class CloudSkipperGeas
extends GeasEffect {
    protected static final int FALLOFF_DURATION = 60;
    protected static final int STAMINA_FALLOFF_START = 5;
    protected int cooldown;
    public int streak;

    public CloudSkipperGeas() {
        super((GeasEffectType)MalumGeasEffectTypes.PACT_OF_THE_CLOUDSKIPPER.get());
    }

    public static void onExplosionKnockback(ExplosionKnockbackEvent event) {
        LivingEntity entity;
        LivingEntity livingEntity;
        Explosion explosion = event.getExplosion();
        ArrayList<LivingEntity> entities = new ArrayList<LivingEntity>();
        Object object = event.getAffectedEntity();
        if (object instanceof LivingEntity) {
            livingEntity = (LivingEntity)object;
            entities.add(livingEntity);
        }
        if (explosion.getIndirectSourceEntity() != null) {
            entities.add(explosion.getIndirectSourceEntity());
        }
        if ((object = explosion.getDirectSourceEntity()) instanceof LivingEntity) {
            livingEntity = (LivingEntity)object;
            entities.add(livingEntity);
        }
        GeasEffect instance = null;
        object = entities.iterator();
        while (object.hasNext() && (instance = CloudSkipperGeas.getInstance(entity = (LivingEntity)object.next())) == null) {
        }
        if (instance instanceof CloudSkipperGeas) {
            CloudSkipperGeas cloudSkipper = (CloudSkipperGeas)instance;
            entity = event.getAffectedEntity();
            if (!explosion.damageCalculator.shouldDamageEntity(explosion, (Entity)entity)) {
                float minimumUpwardsVelocity = 0.5f;
                double horizontalScalar = 2.0;
                double verticalScalar = entity instanceof Player ? 1.25 : 1.75;
                Vec3 knockbackVelocity = event.getKnockbackVelocity();
                if (knockbackVelocity.y < (double)minimumUpwardsVelocity) {
                    double length = knockbackVelocity.length();
                    knockbackVelocity = knockbackVelocity.normalize().multiply(length, (double)minimumUpwardsVelocity, length);
                }
                event.setKnockbackVelocity(knockbackVelocity.multiply(horizontalScalar, verticalScalar, horizontalScalar));
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    player.addEffect(new MobEffectInstance(MalumMobEffects.ASCENSION, 100, 1));
                    ++cloudSkipper.streak;
                    cloudSkipper.setDirty();
                }
            }
        }
    }

    public static GeasEffect getInstance(LivingEntity entity) {
        return GeasEffectHandler.getGeasEffect(entity, MalumGeasEffectTypes.PACT_OF_THE_CLOUDSKIPPER);
    }

    @Override
    public void update(EntityTickEvent.Pre event, LivingEntity entity) {
        if (this.streak == 0) {
            return;
        }
        ++this.cooldown;
        if (this.cooldown == 60) {
            this.streak = Math.max(Mth.floor((float)(this.streak - 2)), 0);
            this.cooldown = 0;
            this.setDirty();
        }
    }

    public void incomingDamageEvent(LivingDamageEvent.Pre event, LivingEntity attacker, LivingEntity target, ItemStack stack) {
        if (event.getSource().is(DamageTypeTags.IS_FALL)) {
            event.setNewDamage(event.getNewDamage() * 2.0f);
        }
    }

    @Override
    public void addTooltipComponents(LivingEntity entity, Consumer<Component> tooltipAcceptor, TooltipFlag tooltipFlag) {
        tooltipAcceptor.accept(ComponentHelper.positiveGeasEffect("rocket_jumping", new Object[0]));
        tooltipAcceptor.accept(ComponentHelper.negativeGeasEffect("wind_charge_exhaustion", new Object[0]));
        tooltipAcceptor.accept(ComponentHelper.negativeGeasEffect("weak_legs", new Object[0]));
        super.addTooltipComponents(entity, tooltipAcceptor, tooltipFlag);
    }

    @Override
    public Multimap<Holder<Attribute>, AttributeModifier> createAttributeModifiers(LivingEntity entity, Multimap<Holder<Attribute>, AttributeModifier> modifiers) {
        if (this.streak >= 5) {
            float modifier = 0.06f * (float)(this.streak - 5);
            this.addAttributeModifier(modifiers, (Holder<Attribute>)Attributes.GRAVITY, modifier, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        }
        return modifiers;
    }
}

