/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.entity.spirit;

import com.sammy.malum.common.entity.FloatingItemDestinationData;
import com.sammy.malum.common.entity.FloatingItemEntity;
import com.sammy.malum.common.item.spirit.SpiritShardItem;
import com.sammy.malum.core.handlers.SoulHarvestHandler;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.entity.MalumEntities;
import com.sammy.malum.visual_effects.SpiritLightSpecs;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.helpers.ItemHelper;
import team.lodestar.lodestone.helpers.SoundHelper;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;

public class SpiritItemEntity
extends FloatingItemEntity {
    public int soundCooldown;

    public SpiritItemEntity(Level level) {
        super((EntityType<? extends FloatingItemEntity>)((EntityType)MalumEntities.NATURAL_SPIRIT.get()), level);
        this.soundCooldown = 20 + this.random.nextInt(100);
        this.maxAge = 4000;
    }

    public SpiritItemEntity(Level level, @Nullable LivingEntity owner, ItemStack stack, Vec3 position, Vec3 velocity) {
        this(level);
        if (owner != null) {
            this.setDestination(new FloatingItemDestinationData(owner));
        }
        this.setItem(stack);
        this.setPos(position);
        this.setDeltaMovement(velocity);
        this.maxAge = 800;
        Item item = stack.getItem();
        if (item instanceof SpiritShardItem) {
            SpiritShardItem spiritShardItem = (SpiritShardItem)item;
            this.setSpirit(spiritShardItem.type);
        }
    }

    public SoundSource getSoundSource() {
        return SoundSource.NEUTRAL;
    }

    @Override
    public void collect(ServerLevel level) {
        ItemStack stack = this.getItem();
        this.getDestination().getEntityCollector(level).ifPresent(collector -> {
            if (stack.getItem() instanceof SpiritShardItem) {
                SoulHarvestHandler.pickupSpirit(collector, stack);
            } else {
                ItemHelper.giveItemToEntity((LivingEntity)collector, (ItemStack)stack);
            }
        });
        if (this.random.nextFloat() < 0.6f) {
            SoundHelper.playSound((Entity)this, (SoundEvent)((SoundEvent)MalumSoundEvents.SPIRIT_PICKUP.get()), (float)0.3f, (float)Mth.nextFloat((RandomSource)this.random, (float)1.1f, (float)2.0f));
        }
        SoundHelper.playSound((Entity)this, (SoundEvent)SoundEvents.ITEM_PICKUP, (float)0.3f, (float)Mth.nextFloat((RandomSource)this.random, (float)1.1f, (float)2.0f));
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            Vec3 motion = this.getDeltaMovement();
            Vec3 norm = motion.normalize().scale((double)0.05f);
            ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(this.level(), this.getOffsetPosition(), this.getSpiritType());
            lightSpecs.getBuilder().setMotion(norm);
            lightSpecs.getBloomBuilder().setMotion(norm);
            lightSpecs.spawnParticles();
        } else if (this.soundCooldown-- == 0) {
            if (this.random.nextFloat() < 0.4f) {
                SoundHelper.playSound((Entity)this, (SoundEvent)((SoundEvent)MalumSoundEvents.ARCANE_WHISPERS.get()), (float)0.3f, (float)Mth.nextFloat((RandomSource)this.random, (float)0.8f, (float)2.0f));
            }
            this.soundCooldown = 40 + this.random.nextInt(40);
        }
    }
}

