/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.entity.nitrate;

import com.sammy.malum.common.entity.nitrate.AbstractNitrateEntity;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumParticles;
import com.sammy.malum.registry.common.entity.MalumEntities;
import com.sammy.malum.visual_effects.SpiritLightSpecs;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectColorData;
import com.sammy.malum.visual_effects.networked.nitrate.NitrateImpactParticleEffectType;
import java.awt.Color;
import java.util.function.Consumer;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.particle.SimpleParticleOptions;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.render_types.LodestoneWorldParticleRenderType;
import team.lodestar.lodestone.systems.particle.world.LodestoneWorldParticle;

public class EthericNitrateEntity
extends AbstractNitrateEntity {
    public static final Color AURIC_YELLOW = new Color(239, 215, 75);
    public static final Color AURIC_PURPLE = new Color(236, 54, 163);
    public static final Color AURIC_RED = new Color(170, 31, 73);
    public static final ColorParticleData AURIC_COLOR_DATA = ColorParticleData.create((Color)AURIC_YELLOW, (Color)AURIC_PURPLE).setEasing(Easing.SINE_IN_OUT).setCoefficient(0.9f).build();

    public EthericNitrateEntity(Level level) {
        super((EntityType<? extends AbstractNitrateEntity>)((EntityType)MalumEntities.ETHERIC_NITRATE.get()), level);
    }

    public EthericNitrateEntity(LivingEntity owner) {
        super((EntityType<? extends AbstractNitrateEntity>)((EntityType)MalumEntities.ETHERIC_NITRATE.get()), owner, owner.level());
    }

    @Override
    public float getExplosionRadius() {
        return 2.25f;
    }

    @Override
    public int getMaxPierce() {
        return 3;
    }

    @Override
    public NitrateImpactParticleEffectType getImpactParticleEffect() {
        return MalumParticleEffectTypes.ETHERIC_NITRATE_IMPACT;
    }

    @Override
    public MalumNetworkedParticleEffectColorData getImpactParticleEffectColor() {
        return new MalumNetworkedParticleEffectColorData(AURIC_COLOR_DATA);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void spawnParticles() {
        float scalar;
        float f = scalar = this.age > 1190 ? 1.0f - (float)(this.age - 1200 + 10) / 10.0f : 1.0f;
        if (this.age < 5) {
            scalar = (float)this.age / 5.0f;
        }
        Vec3 norm = this.getDeltaMovement().normalize().scale((double)0.05f);
        ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(this.level(), this.position(), AURIC_COLOR_DATA);
        lightSpecs.getBuilder().multiplyLifetime(1.5f).setMotion(norm);
        lightSpecs.getBloomBuilder().multiplyLifetime(1.5f).setMotion(norm);
        lightSpecs.spawnParticles();
        Color startingSmokeColor = this.age < 3 ? AbstractNitrateEntity.SECOND_SMOKE_COLOR : AURIC_YELLOW;
        for (int i = 0; i < 3; ++i) {
            int lifetime = (int)((float)RandomHelper.randomBetween((RandomSource)this.random, (int)60, (int)80) * (1.0f - (float)i / 3.0f));
            SpinParticleData spinData = SpinParticleData.createRandomDirection((RandomSource)this.random, (float)0.0f, (float)RandomHelper.randomBetween((RandomSource)this.random, (float)0.0f, (float)0.4f), (float)0.0f).randomSpinOffset(this.random).build();
            Consumer<LodestoneWorldParticle> behavior = p -> p.setParticleSpeed(p.getParticleSpeed().scale((double)0.98f));
            WorldParticleBuilder.create(MalumParticles.STRANGE_SMOKE).setTransparencyData(GenericParticleData.create((float)(0.7f * scalar), (float)(0.9f * scalar), (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN).build()).setSpinData(spinData).setScaleData(GenericParticleData.create((float)(0.2f * scalar), (float)(0.4f * scalar), (float)(0.6f * scalar)).setEasing(Easing.QUINTIC_OUT, Easing.SINE_IN).build()).setColorData(ColorParticleData.create((Color)startingSmokeColor, (Color)AbstractNitrateEntity.SECOND_SMOKE_COLOR).setEasing(Easing.QUINTIC_OUT).build()).setLifetime(Math.min(6 + this.age * 3, lifetime)).setLifeDelay(1).enableNoClip().enableForcedSpawn().setSpritePicker(SimpleParticleOptions.ParticleSpritePicker.WITH_AGE).addTickActor(behavior).setRenderType((ParticleRenderType)LodestoneWorldParticleRenderType.LUMITRANSPARENT).spawn(this.level(), this.position().x, this.position().y, this.position().z);
        }
    }
}

