/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.entity;

import com.sammy.malum.common.entity.FloatingEntity;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.common.MalumSpiritTypes;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public abstract class FloatingItemEntity
extends FloatingEntity {
    protected static final EntityDataAccessor<ItemStack> DATA_ITEM_STACK = SynchedEntityData.defineId(FloatingItemEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    protected static final EntityDataAccessor<String> DATA_SPIRIT_GLOW = SynchedEntityData.defineId(FloatingItemEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);

    public FloatingItemEntity(EntityType<? extends FloatingItemEntity> type, Level level) {
        super(type, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_ITEM_STACK, (Object)ItemStack.EMPTY);
        builder.define(DATA_SPIRIT_GLOW, (Object)MalumSpiritTypes.ARCANE_SPIRIT.getIdentifier());
    }

    @Override
    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        ItemStack itemstack = this.getItem();
        if (!itemstack.isEmpty()) {
            pCompound.put("item", this.getItem().save((HolderLookup.Provider)this.registryAccess()));
        }
        pCompound.putString("spiritType", this.getSpiritType().getIdentifier());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.setItem(ItemStack.parse((HolderLookup.Provider)this.registryAccess(), (Tag)pCompound.getCompound("item")).orElse(ItemStack.EMPTY));
        this.setSpirit(pCompound.getString("spiritType"));
    }

    @Override
    public void tick() {
        super.tick();
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            if (this.age >= 40) {
                if (this.getDestination() != null && this.getDestination().isValid(level2)) {
                    return;
                }
                BlockHitResult clipResult = level2.clip(new ClipContext(this.position(), this.position().add(this.getDeltaMovement()), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
                if (clipResult.isInside()) {
                    Vec3 itemPos = this.position().subtract(this.getDeltaMovement().scale(0.75));
                    ItemEntity entity = new ItemEntity((Level)level2, itemPos.x, itemPos.y, itemPos.z, this.getItem());
                    entity.setDeltaMovement(this.getDeltaMovement().scale((double)-0.4f));
                    level2.addFreshEntity((Entity)entity);
                    this.discard();
                }
            }
        }
    }

    public ItemStack getItem() {
        return (ItemStack)this.getEntityData().get(DATA_ITEM_STACK);
    }

    public void setItem(ItemStack pStack) {
        this.getEntityData().set(DATA_ITEM_STACK, (Object)pStack);
    }

    public MalumSpiritType getSpiritType() {
        return MalumSpiritTypes.SPIRITS.get(this.getEntityData().get(DATA_SPIRIT_GLOW));
    }

    public void setSpirit(String spiritIdentifier) {
        this.getEntityData().set(DATA_SPIRIT_GLOW, (Object)spiritIdentifier);
    }

    public void setSpirit(MalumSpiritType spiritType) {
        this.setSpirit(spiritType.getIdentifier());
    }
}

