/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.entity;

import com.sammy.malum.common.entity.FloatingItemDestinationData;
import java.util.Optional;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.rendering.trail.TrailPointBuilder;

public abstract class FloatingEntity
extends Entity {
    public final TrailPointBuilder trail = TrailPointBuilder.create((int)10);
    public final TrailPointBuilder longTrail = TrailPointBuilder.create((int)30);
    protected FloatingItemDestinationData destination;
    protected float hoverOffset;
    protected int age;
    protected int maxAge;
    protected int movementWindUp;
    protected int hoverWindUp;

    public FloatingEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
        this.noPhysics = false;
        this.hoverOffset = (float)(Math.random() * Math.PI * 2.0);
    }

    public abstract void collect(ServerLevel var1);

    public void setDestination(FloatingItemDestinationData destination) {
        this.destination = destination;
    }

    public FloatingItemDestinationData getDestination() {
        return this.destination;
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.destination = FloatingItemDestinationData.load(compound);
        this.age = compound.getInt("age");
        this.maxAge = compound.getInt("maxAge");
        this.movementWindUp = compound.getInt("movementWindUp");
        this.hoverWindUp = compound.getInt("hoverWindUp");
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        if (this.destination != null) {
            this.destination.save(compound);
        }
        compound.putInt("age", this.age);
        compound.putInt("maxAge", this.maxAge);
        compound.putInt("movementWindUp", this.movementWindUp);
        compound.putInt("hoverWindUp", this.hoverWindUp);
    }

    public void tick() {
        if (this.age > this.maxAge) {
            this.discard();
            return;
        }
        this.baseTick();
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            if (this.destination != null && this.destination.isValid(level2)) {
                float distance = (float)this.destination.getDistance(level2, this);
                Optional<Vec3> destination = this.destination.getDestination(level2);
                if (destination.isPresent()) {
                    float windUpDuration = this.getWindUpDuration();
                    Vec3 targetPos = destination.get();
                    if ((float)this.movementWindUp < windUpDuration) {
                        ++this.movementWindUp;
                    }
                    float delta = Mth.clamp((float)((float)this.movementWindUp / windUpDuration), (float)0.0f, (float)1.0f);
                    float velocity = Mth.clamp((float)(delta - 0.25f), (float)0.0f, (float)0.75f) * 3.0f;
                    Vec3 desiredMotion = targetPos.subtract(this.position()).normalize().multiply((double)velocity, (double)velocity, (double)velocity);
                    float easing = this.getMotionEasingRatio(delta, distance);
                    this.setDeltaMovement(this.getDeltaMovement().lerp(desiredMotion, (double)easing));
                    if (distance < 0.4f) {
                        this.collect(level2);
                        this.remove(Entity.RemovalReason.DISCARDED);
                    }
                }
            } else {
                if (this.movementWindUp > 0) {
                    --this.movementWindUp;
                }
                if (this.age >= 40) {
                    float windUpDuration = this.getWindUpDuration();
                    float gravity = 0.004f * (windUpDuration - (float)this.movementWindUp) / windUpDuration;
                    this.setDeltaMovement(this.getDeltaMovement().subtract(0.0, (double)gravity, 0.0).multiply((double)0.9f, (double)0.96f, (double)0.9f));
                }
                if (level2.getGameTime() % 20L == 0L) {
                    ServerPlayer nearestPlayer = null;
                    float minimumDistance = 6.0f;
                    for (ServerPlayer player : level2.players()) {
                        float distance = player.distanceTo((Entity)this);
                        if (!(distance < minimumDistance) || !player.hasLineOfSight((Entity)this)) continue;
                        nearestPlayer = player;
                        minimumDistance = distance;
                    }
                    if (nearestPlayer != null && nearestPlayer.isAlive()) {
                        this.setDestination(new FloatingItemDestinationData(nearestPlayer.getUUID()));
                    }
                }
            }
        } else {
            for (int i = 0; i < 2; ++i) {
                float progress = (float)(i + 1) * 0.5f;
                Vec3 position = this.getPosition(progress).add(0.0, (double)this.getYOffset(progress), 0.0);
                this.trail.addTrailPoint(position);
                this.longTrail.addTrailPoint(position);
            }
            this.trail.tickTrailPoints();
            this.longTrail.tickTrailPoints();
        }
        this.applyMovement();
        ++this.age;
    }

    public void lerpMotion(double x, double y, double z) {
        this.setDeltaMovement(x, y, z);
        if (this.xRotO == 0.0f && this.yRotO == 0.0f) {
            double d0 = Math.sqrt(x * x + z * z);
            this.setXRot((float)(Mth.atan2((double)y, (double)d0) * 180.0 / 3.1415927410125732));
            this.setYRot((float)(Mth.atan2((double)x, (double)z) * 180.0 / 3.1415927410125732));
            this.xRotO = this.getXRot();
            this.yRotO = this.getYRot();
            this.moveTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), this.getXRot());
        }
    }

    public boolean isPickable() {
        return true;
    }

    public int getWindUpDuration() {
        return 50;
    }

    public float getMotionEasingRatio(float windUpDelta, float distance) {
        return 0.005f + windUpDelta * 0.01f + 1.0f / Math.max(distance, 1.0f) * 0.025f;
    }

    public float getFriction() {
        return 0.96f;
    }

    protected void applyMovement() {
        this.checkInsideBlocks();
        Vec3 vec3 = this.getDeltaMovement();
        double d0 = this.getX() + vec3.x;
        double d1 = this.getY() + vec3.y;
        double d2 = this.getZ() + vec3.z;
        this.updateRotation();
        float friction = this.getFriction();
        if (this.isInWater()) {
            for (int i = 0; i < 4; ++i) {
                this.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, d0 - vec3.x * 0.25, d1 - vec3.y * 0.25, d2 - vec3.z * 0.25, vec3.x, vec3.y, vec3.z);
            }
            friction *= 0.825f;
        }
        this.setDeltaMovement(vec3.scale((double)friction));
        this.applyGravity();
        this.setPos(d0, d1, d2);
    }

    public Vec3 getOffsetPosition() {
        return this.position().add(0.0, (double)this.getYOffset(0.0f), 0.0);
    }

    public float getYOffset(float partialTicks) {
        float windUpDuration = this.getWindUpDuration();
        float offsetStrength = Easing.CIRC_IN_OUT.clamped(((float)this.age + partialTicks) / windUpDuration, 0.0f, 1.0f);
        return Mth.sin((float)(((float)this.age + partialTicks) / 6.0f + this.hoverOffset)) * (0.5f - offsetStrength * 0.25f);
    }

    public float getRotation(float partialTicks) {
        return ((float)this.age + partialTicks) / 10.0f + this.hoverOffset;
    }

    protected void updateRotation() {
        Vec3 vec3 = this.getDeltaMovement();
        double d0 = vec3.horizontalDistance();
        this.setXRot(FloatingEntity.lerpRotation(this.xRotO, (float)(Mth.atan2((double)vec3.y, (double)d0) * 180.0 / 3.1415927410125732)));
        this.setYRot(FloatingEntity.lerpRotation(this.yRotO, (float)(Mth.atan2((double)vec3.x, (double)vec3.z) * 180.0 / 3.1415927410125732)));
    }

    protected static float lerpRotation(float currentRotation, float targetRotation) {
        while (targetRotation - currentRotation < -180.0f) {
            currentRotation -= 360.0f;
        }
        while (targetRotation - currentRotation >= 180.0f) {
            currentRotation += 360.0f;
        }
        return Mth.lerp((float)0.2f, (float)currentRotation, (float)targetRotation);
    }

    public float getHoverOffset() {
        return this.hoverOffset;
    }

    public int getAge() {
        return this.age;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public int getMovementWindUp() {
        return this.movementWindUp;
    }

    public int getHoverWindUp() {
        return this.hoverWindUp;
    }
}

