/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.storage.jar;

import com.mojang.serialization.DynamicOps;
import com.sammy.malum.common.data.component.SoulwovenPouchContentsComponent;
import com.sammy.malum.common.data.component.SpiritJarContentsComponent;
import com.sammy.malum.common.item.spirit.SpiritShardItem;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.block.MalumBlockEntities;
import com.sammy.malum.registry.common.item.MalumDataComponents;
import com.sammy.malum.visual_effects.SpiritLightSpecs;
import java.util.ArrayList;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.helpers.SoundHelper;
import team.lodestar.lodestone.helpers.block.BlockStateHelper;
import team.lodestar.lodestone.systems.blockentity.IItemHandlerSupplier;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntity;

public class SpiritJarBlockEntity
extends LodestoneBlockEntity
implements IItemHandlerSupplier {
    public SpiritJarContentsComponent contents;
    private long lastClickTime;
    private UUID lastClickUUID;
    private final Supplier<IItemHandler> inventory = () -> new IItemHandler(){

        public int getSlots() {
            return 2;
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            if (slot == 0 && SpiritJarBlockEntity.this.contents != null) {
                return SpiritJarBlockEntity.this.contents.createStack();
            }
            return ItemStack.EMPTY;
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            Item item = stack.getItem();
            if (!(item instanceof SpiritShardItem)) {
                return stack;
            }
            SpiritShardItem shardItem = (SpiritShardItem)item;
            if (slot == 1) {
                if (!simulate) {
                    if (SpiritJarBlockEntity.this.contents == null) {
                        SpiritJarBlockEntity.this.contents = new SpiritJarContentsComponent(shardItem.type, stack.getCount());
                    } else if (SpiritJarBlockEntity.this.contents.spirit().equals(shardItem.type)) {
                        SpiritJarBlockEntity.this.contents = SpiritJarBlockEntity.this.contents.add(stack.getCount());
                    }
                    if (!((SpiritJarBlockEntity)SpiritJarBlockEntity.this).level.isClientSide) {
                        BlockStateHelper.updateAndNotifyState((Level)SpiritJarBlockEntity.this.level, (BlockPos)SpiritJarBlockEntity.this.worldPosition);
                    }
                }
                return ItemStack.EMPTY;
            }
            return stack;
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (SpiritJarBlockEntity.this.contents == null) {
                return ItemStack.EMPTY;
            }
            int amountToExtract = Math.min(SpiritJarBlockEntity.this.contents.count(), amount);
            ItemStack result = SpiritJarBlockEntity.this.contents.createStack(amountToExtract);
            if (!simulate) {
                SpiritJarBlockEntity.this.contents = SpiritJarBlockEntity.this.contents.remove(amountToExtract);
                if (!((SpiritJarBlockEntity)SpiritJarBlockEntity.this).level.isClientSide) {
                    BlockStateHelper.updateAndNotifyState((Level)SpiritJarBlockEntity.this.level, (BlockPos)SpiritJarBlockEntity.this.worldPosition);
                }
            }
            return result;
        }

        public int getSlotLimit(int slot) {
            if (slot == 0) {
                return SpiritJarBlockEntity.this.contents == null ? 64 : Math.min(64, SpiritJarBlockEntity.this.contents.count());
            }
            return 64;
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            Item item = stack.getItem();
            if (item instanceof SpiritShardItem) {
                SpiritShardItem spiritShardItem = (SpiritShardItem)item;
                return SpiritJarBlockEntity.this.contents == null || SpiritJarBlockEntity.this.contents.spirit().equals(spiritShardItem.type);
            }
            return false;
        }
    };

    public SpiritJarBlockEntity(BlockEntityType<? extends SpiritJarBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public SpiritJarBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType<? extends SpiritJarBlockEntity>)((BlockEntityType)MalumBlockEntities.SPIRIT_JAR.get()), pos, state);
    }

    public ItemInteractionResult onUseWithItem(Player player, ItemStack pStack, InteractionHand pHand) {
        if (this.getLevel() == null) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        int inserted = this.getLevel().getGameTime() - this.lastClickTime < 10L && player.getUUID().equals(this.lastClickUUID) ? this.insertAllSpirits(player) : this.insertHeldItem(player);
        if (inserted > 0) {
            SoundHelper.playSound((Entity)player, (SoundEvent)((SoundEvent)MalumSoundEvents.PEDESTAL_SPIRIT_INSERT.get()), (SoundSource)SoundSource.BLOCKS, (float)0.7f, (float)RandomHelper.randomBetween((RandomSource)player.getRandom(), (float)0.8f, (float)1.2f));
        }
        this.lastClickTime = this.getLevel().getGameTime();
        this.lastClickUUID = player.getUUID();
        if (!this.level.isClientSide) {
            BlockStateHelper.updateAndNotifyState((Level)this.level, (BlockPos)this.worldPosition);
        }
        return ItemInteractionResult.sidedSuccess((boolean)this.level.isClientSide);
    }

    public int insertHeldItem(Player player) {
        int count = 0;
        ItemStack playerStack = player.getInventory().getSelected();
        if (!playerStack.isEmpty()) {
            count = this.insertFromStack(playerStack, player);
        }
        return count;
    }

    public int insertAllSpirits(Player player) {
        if (this.contents == null) {
            return 0;
        }
        int count = 0;
        int n = player.getInventory().getContainerSize();
        for (int i = 0; i < n; ++i) {
            ItemStack subStack = player.getInventory().getItem(i);
            if (subStack.isEmpty()) continue;
            int subCount = this.insertFromStack(subStack, player);
            if (subCount > 0 && subStack.getCount() == 0) {
                player.getInventory().setItem(i, ItemStack.EMPTY);
            }
            count += subCount;
        }
        return count;
    }

    public int insertFromStack(ItemStack stack, Player player) {
        int inserted = 0;
        if (stack.has(MalumDataComponents.SOULWOVEN_POUCH_CONTENTS)) {
            SoulwovenPouchContentsComponent pouchContents = (SoulwovenPouchContentsComponent)stack.get(MalumDataComponents.SOULWOVEN_POUCH_CONTENTS);
            if (!pouchContents.isEmpty()) {
                ArrayList<ItemStack> remainingSpirits = new ArrayList<ItemStack>();
                for (ItemStack item : pouchContents.items()) {
                    inserted += this.insertFromStack(item, player);
                    if (item.isEmpty()) continue;
                    remainingSpirits.add(item);
                }
                SoundHelper.playSound((Entity)player, (SoundEvent)SoundEvents.BUNDLE_DROP_CONTENTS, (SoundSource)SoundSource.BLOCKS, (float)1.2f, (float)RandomHelper.randomBetween((RandomSource)player.getRandom(), (float)0.8f, (float)1.2f));
                stack.set(MalumDataComponents.SOULWOVEN_POUCH_CONTENTS, (Object)new SoulwovenPouchContentsComponent(remainingSpirits));
            }
            return inserted;
        }
        Item item = stack.getItem();
        if (item instanceof SpiritShardItem) {
            SpiritShardItem shard = (SpiritShardItem)item;
            if (this.contents == null || this.contents.spirit().equals(shard.type)) {
                if (this.contents == null) {
                    this.contents = new SpiritJarContentsComponent(shard.type, stack.getCount());
                } else if (this.contents.spirit().equals(shard.type)) {
                    this.contents = this.contents.add(stack.getCount());
                }
                inserted += stack.getCount();
                stack.shrink(stack.getCount());
            }
        }
        return inserted;
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        components.set(MalumDataComponents.SPIRIT_JAR_CONTENTS, (Object)this.contents);
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        this.contents = (SpiritJarContentsComponent)componentInput.get(MalumDataComponents.SPIRIT_JAR_CONTENTS);
    }

    public void removeComponentsFromTag(CompoundTag tag) {
        tag.remove("contents");
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        if (this.contents != null) {
            tag.put("contents", (Tag)SpiritJarContentsComponent.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.contents).getOrThrow());
        }
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        this.contents = SpiritJarContentsComponent.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("contents")).result().orElse(null);
        super.loadAdditional(tag, registries);
    }

    public void tick() {
        if (this.level.isClientSide && this.contents != null) {
            SpiritLightSpecs.rotatingLightSpecs(this.level, this.getItemPos(), this.contents.spirit(), 0.4f, 3);
        }
    }

    public Vec3 getItemPos() {
        double time = (float)this.level.getGameTime() * 0.05f % 6.28f;
        double x = (float)this.getBlockPos().getX() + 0.5f;
        double y = (float)this.getBlockPos().getY() + 0.5f + (float)Math.sin(time) * 0.2f;
        double z = (float)this.getBlockPos().getZ() + 0.5f;
        return new Vec3(x, y, z);
    }

    public IItemHandler getInventory(Direction direction) {
        return this.inventory.get();
    }
}

