/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.curiosities.spirit_catalyzer;

import com.sammy.malum.common.block.AugmentBlockEntityInventory;
import com.sammy.malum.common.block.MalumBlockEntityInventory;
import com.sammy.malum.common.block.curiosities.spirit_catalyzer.CatalyzerArtificeModifierSourceInstance;
import com.sammy.malum.core.systems.artifice.ArtificeModifierSourceInstance;
import com.sammy.malum.core.systems.artifice.IArtificeModifierSource;
import com.sammy.malum.registry.common.block.MalumBlockEntities;
import com.sammy.malum.registry.common.block.MalumBlocks;
import com.sammy.malum.registry.common.item.MalumDataComponents;
import com.sammy.malum.visual_effects.SpiritCrucibleParticleEffects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandler;
import team.lodestar.lodestone.systems.blockentity.IItemHandlerSupplier;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntity;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntityInventory;
import team.lodestar.lodestone.systems.multiblock.HorizontalDirectionStructure;
import team.lodestar.lodestone.systems.multiblock.MultiBlockCoreEntity;
import team.lodestar.lodestone.systems.multiblock.MultiBlockStructure;

public class SpiritCatalyzerCoreBlockEntity
extends MultiBlockCoreEntity
implements IArtificeModifierSource,
IItemHandlerSupplier {
    public static final Supplier<HorizontalDirectionStructure> STRUCTURE = () -> HorizontalDirectionStructure.of((MultiBlockStructure.StructurePiece[])new MultiBlockStructure.StructurePiece[]{new MultiBlockStructure.StructurePiece(0, 1, 0, ((Block)MalumBlocks.SPIRIT_CATALYZER_COMPONENT.get()).defaultBlockState())});
    public static final Vec3 CATALYZER_ITEM_OFFSET = new Vec3(0.5, 2.0, 0.5);
    public static final Vec3 CATALYZER_AUGMENT_OFFSET = new Vec3(0.5, 2.75, 0.5);
    public LodestoneBlockEntityInventory inventory = MalumBlockEntityInventory.singleItemStack((LodestoneBlockEntity)this).onContentsChanged(() -> this.triggerRecalibration(this.level, pos));
    public LodestoneBlockEntityInventory augmentInventory = AugmentBlockEntityInventory.augmentInventory((LodestoneBlockEntity)this, 1).onContentsChanged(() -> this.triggerRecalibration(this.level, pos));
    public CatalyzerArtificeModifierSourceInstance modifier;
    public float burnTicks;

    public SpiritCatalyzerCoreBlockEntity(BlockEntityType<? extends SpiritCatalyzerCoreBlockEntity> type, MultiBlockStructure structure, BlockPos pos, BlockState state) {
        super(type, structure, pos, state);
    }

    public SpiritCatalyzerCoreBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType<? extends SpiritCatalyzerCoreBlockEntity>)((BlockEntityType)MalumBlockEntities.SPIRIT_CATALYZER.get()), (MultiBlockStructure)STRUCTURE.get(), pos, state);
    }

    public IItemHandler getInventory(Direction direction) {
        return this.inventory;
    }

    @Override
    public ArtificeModifierSourceInstance createFocusingModifierInstance() {
        this.modifier = new CatalyzerArtificeModifierSourceInstance(this);
        return this.modifier;
    }

    @Override
    public Optional<ArtificeModifierSourceInstance> getFocusingModifierInstance() {
        return Optional.ofNullable(this.modifier);
    }

    public ItemInteractionResult onUse(Player pPlayer, InteractionHand pHand) {
        ItemStack augment;
        ItemStack result;
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            return ItemInteractionResult.CONSUME;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ItemStack heldStack = pPlayer.getItemInHand(pHand);
        boolean isAugment = heldStack.has(MalumDataComponents.ARTIFICE_AUGMENT);
        if (!(isAugment && !heldStack.isEmpty() || (result = this.inventory.interact(serverLevel, pPlayer, pHand)).isEmpty())) {
            return ItemInteractionResult.SUCCESS;
        }
        if ((isAugment || heldStack.isEmpty()) && !(augment = this.augmentInventory.interact(serverLevel, pPlayer, pHand)).isEmpty()) {
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.FAIL;
    }

    public void onBreak(@Nullable Player player) {
        if (!this.level.isClientSide) {
            this.inventory.dumpItems(this.level, this.worldPosition);
            this.augmentInventory.dumpItems(this.level, this.worldPosition);
        }
        super.onBreak(player);
    }

    public void tick() {
        if (this.level.isClientSide) {
            SpiritCrucibleParticleEffects.passiveSpiritCatalyzerParticles(this);
        }
    }

    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider registryLookup) {
        if (this.burnTicks != 0.0f) {
            compound.putFloat("burnTicks", this.burnTicks);
        }
        this.inventory.save(registryLookup, compound);
        this.augmentInventory.save(registryLookup, compound, "augmentInventory");
        super.saveAdditional(compound, registryLookup);
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        this.burnTicks = compound.getFloat("burnTicks");
        this.inventory.load(registries, compound);
        this.augmentInventory.load(registries, compound, "augmentInventory");
        super.loadAdditional(compound, registries);
    }
}

