/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.curiosities.spirit_altar;

import com.sammy.malum.common.block.MalumBlockEntityInventory;
import com.sammy.malum.common.block.MalumSpiritBlockEntityInventory;
import com.sammy.malum.common.block.curiosities.spirit_altar.AltarCraftingHelper;
import com.sammy.malum.common.block.curiosities.spirit_altar.AltarSoundInstance;
import com.sammy.malum.common.block.curiosities.spirit_altar.IAltarAccelerator;
import com.sammy.malum.common.block.storage.IMalumSpecialItemAccessPoint;
import com.sammy.malum.common.recipe.SpiritInfusionRecipe;
import com.sammy.malum.core.systems.recipe.SpiritBasedRecipeInput;
import com.sammy.malum.core.systems.recipe.SpiritIngredient;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.MalumSpiritTypes;
import com.sammy.malum.registry.common.block.MalumBlockEntities;
import com.sammy.malum.registry.common.recipe.MalumRecipeTypes;
import com.sammy.malum.visual_effects.SpiritAltarParticleEffects;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectColorData;
import com.sammy.malum.visual_effects.networked.altar.SpiritAltarEatItemParticleEffect;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import team.lodestar.lodestone.helpers.NBTHelper;
import team.lodestar.lodestone.helpers.VecHelper;
import team.lodestar.lodestone.helpers.block.BlockEntityHelper;
import team.lodestar.lodestone.helpers.block.BlockStateHelper;
import team.lodestar.lodestone.systems.blockentity.IItemHandlerSupplier;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntity;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntityInventory;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.recipe.LodestoneRecipeType;

public class SpiritAltarBlockEntity
extends LodestoneBlockEntity
implements IItemHandlerSupplier {
    public static final Vec3 ALTAR_ITEM_OFFSET = new Vec3(0.5, 1.25, 0.5);
    public static final int HORIZONTAL_RANGE = 4;
    public static final int VERTICAL_RANGE = 3;
    private static final int WARMUP_DURATION = 30;
    public float speed = 1.0f;
    public int progress;
    public int idleProgress;
    public float warmupTimer;
    public List<BlockPos> acceleratorPositions = new ArrayList<BlockPos>();
    public List<IAltarAccelerator> accelerators = new ArrayList<IAltarAccelerator>();
    public float spiritAmount;
    public float spiritSpin;
    public boolean isCrafting;
    public LodestoneBlockEntityInventory inventory;
    public LodestoneBlockEntityInventory extrasInventory;
    public LodestoneBlockEntityInventory spiritInventory;
    public Map<SpiritInfusionRecipe, AltarCraftingHelper.Ranking> possibleRecipes = new HashMap<SpiritInfusionRecipe, AltarCraftingHelper.Ranking>();
    public SpiritInfusionRecipe recipe;
    public Supplier<IItemHandler> exposedInventory = () -> new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inventory, this.spiritInventory});

    public SpiritAltarBlockEntity(BlockEntityType<? extends SpiritAltarBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public SpiritAltarBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)MalumBlockEntities.SPIRIT_ALTAR.get(), pos, state);
        this.inventory = MalumBlockEntityInventory.singleStackNotSpirit(this).onContentsChanged(this::recalculateRecipes);
        this.extrasInventory = MalumBlockEntityInventory.stacksNotSpirits(this, 8);
        this.spiritInventory = MalumSpiritBlockEntityInventory.spiritStacks(this, MalumSpiritTypes.SPIRITS.size()).onContentsChanged(this::recalculateRecipes);
    }

    public IItemHandler getInventory(Direction direction) {
        return this.exposedInventory.get();
    }

    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        compound.putInt("progress", this.progress);
        compound.putInt("idleProgress", this.idleProgress);
        compound.putFloat("warmupTimer", this.warmupTimer);
        compound.putFloat("speed", this.speed);
        compound.putFloat("spiritAmount", this.spiritAmount);
        CompoundTag acceleratorData = new CompoundTag();
        acceleratorData.putInt("acceleratorAmount", this.acceleratorPositions.size());
        for (int i = 0; i < this.acceleratorPositions.size(); ++i) {
            acceleratorData.put("acceleratorPosition_" + i, (Tag)NBTHelper.saveBlockPos((BlockPos)this.acceleratorPositions.get(i)));
        }
        compound.put("acceleratorData", (Tag)acceleratorData);
        this.inventory.save(pRegistries, compound);
        this.spiritInventory.save(pRegistries, compound, "spiritInventory");
        this.extrasInventory.save(pRegistries, compound, "extrasInventory");
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        this.progress = compound.getInt("progress");
        this.idleProgress = compound.getInt("idleProgress");
        this.warmupTimer = compound.getFloat("warmupTimer");
        this.speed = compound.getFloat("speed");
        this.spiritAmount = compound.getFloat("spiritAmount");
        this.acceleratorPositions.clear();
        this.accelerators.clear();
        CompoundTag acceleratorData = compound.getCompound("acceleratorData");
        int amount = acceleratorData.getInt("acceleratorAmount");
        for (int i = 0; i < amount; ++i) {
            BlockEntity blockEntity;
            BlockPos pos = NBTHelper.readBlockPos((CompoundTag)acceleratorData.getCompound("acceleratorPosition_" + i));
            if (pos == null || this.level == null || !((blockEntity = this.level.getBlockEntity(pos)) instanceof IAltarAccelerator)) continue;
            IAltarAccelerator accelerator = (IAltarAccelerator)blockEntity;
            this.acceleratorPositions.add(pos);
            this.accelerators.add(accelerator);
        }
        this.inventory.load(pRegistries, compound);
        this.spiritInventory.load(pRegistries, compound, "spiritInventory");
        this.extrasInventory.load(pRegistries, compound, "extrasInventory");
        this.loadWithLevel(level -> {
            this.recalculateRecipes();
            this.recalibrateAccelerators();
            if (level.isClientSide && this.isCrafting) {
                AltarSoundInstance.playSound(this);
            }
        });
        super.loadAdditional(compound, pRegistries);
    }

    public void onBreak(@Nullable Player player) {
        this.inventory.dumpItems(this.level, this.worldPosition);
        this.spiritInventory.dumpItems(this.level, this.worldPosition);
        this.extrasInventory.dumpItems(this.level, this.worldPosition);
    }

    public ItemInteractionResult onUse(Player pPlayer, InteractionHand pHand) {
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            return ItemInteractionResult.CONSUME;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ItemStack spiritResult = this.spiritInventory.interact(serverLevel, pPlayer, pHand);
        if (!spiritResult.isEmpty()) {
            return ItemInteractionResult.SUCCESS;
        }
        ItemStack result = this.inventory.interact(serverLevel, pPlayer, pHand);
        if (!result.isEmpty()) {
            return ItemInteractionResult.SUCCESS;
        }
        return super.onUse(pPlayer, pHand);
    }

    public void tick() {
        super.tick();
        this.spiritAmount = Math.max(1.0f, Mth.lerp((float)0.1f, (float)this.spiritAmount, (float)this.spiritInventory.getFilledSlotCount()));
        ItemStack primeItem = this.inventory.getStackInSlot(0);
        if (!primeItem.isEmpty()) {
            ++this.idleProgress;
            int progressCap = (int)(20.0f / this.speed);
            if (this.idleProgress >= progressCap) {
                this.recalculateRecipes();
                this.idleProgress = 0;
                BlockStateHelper.updateAndNotifyState((Level)this.level, (BlockPos)this.worldPosition);
            }
        }
        if (!this.possibleRecipes.isEmpty()) {
            this.warmupTimer += 1.0f;
            if (!this.isCrafting && this.recipe != null) {
                this.isCrafting = true;
                BlockStateHelper.updateAndNotifyState((Level)this.level, (BlockPos)this.worldPosition);
            } else if (this.isCrafting && this.recipe == null) {
                this.isCrafting = false;
                BlockStateHelper.updateAndNotifyState((Level)this.level, (BlockPos)this.worldPosition);
            }
            this.progress = this.isCrafting ? this.progress + 1 : this.progress;
            Level level = this.level;
            if (level instanceof ServerLevel) {
                boolean success;
                int progressCap;
                boolean canAccelerate;
                ServerLevel serverLevel = (ServerLevel)level;
                if (serverLevel.getGameTime() % 20L == 0L && !(canAccelerate = this.accelerators.stream().allMatch(IAltarAccelerator::canAccelerate))) {
                    this.recalibrateAccelerators();
                }
                if (this.progress >= (progressCap = (int)(300.0f / this.speed)) && (success = this.consume(serverLevel))) {
                    this.craft(serverLevel);
                }
            }
        } else {
            this.isCrafting = false;
            this.progress = 0;
            this.warmupTimer = Mth.clamp((float)(this.warmupTimer - 1.0f), (float)0.0f, (float)30.0f);
        }
        if (this.level.isClientSide) {
            this.spiritSpin += 1.0f + this.getSpinUp(Easing.SINE_IN_OUT) * 0.05f + this.speed * 0.5f;
            SpiritAltarParticleEffects.passiveSpiritAltarParticles(this);
        }
    }

    private void recalculateRecipes() {
        boolean hadRecipe = this.recipe != null;
        this.inventory.updateInventoryCaches();
        ItemStack stack = this.inventory.getStackInSlot(0);
        if (!stack.isEmpty()) {
            List all = LodestoneRecipeType.getRecipes((Level)this.level, (RecipeType)((RecipeType)MalumRecipeTypes.SPIRIT_INFUSION.get()));
            List<SpiritInfusionRecipe> recipes = all.stream().filter(r -> r.matches(new SpiritBasedRecipeInput(stack, (List<ItemStack>)this.spiritInventory.nonEmptyItemStacks), this.level)).toList();
            this.possibleRecipes.clear();
            IItemHandlerModifiable pedestalItems = AltarCraftingHelper.createPedestalInventoryCapture(AltarCraftingHelper.capturePedestals(this.level, this.worldPosition));
            for (SpiritInfusionRecipe recipe : recipes) {
                this.possibleRecipes.put(recipe, AltarCraftingHelper.rankRecipe(recipe, stack, (IItemHandlerModifiable)this.spiritInventory, pedestalItems, (IItemHandlerModifiable)this.extrasInventory));
            }
            this.recipe = this.possibleRecipes.entrySet().stream().filter(it -> it.getValue() != null).max(Map.Entry.comparingByValue()).map(Map.Entry::getKey).orElse(null);
        } else {
            this.recipe = null;
            this.possibleRecipes.clear();
        }
        if (hadRecipe && this.recipe == null && this.level != null) {
            this.extrasInventory.dumpItems(this.level, this.worldPosition);
        }
        if (this.recipe != null) {
            this.isCrafting = true;
        }
    }

    public boolean consume(ServerLevel level) {
        if (this.recipe == null) {
            return false;
        }
        if (this.recipe.extraIngredients.isEmpty()) {
            return true;
        }
        List<IMalumSpecialItemAccessPoint> pedestalItems = AltarCraftingHelper.capturePedestals((Level)level, this.worldPosition);
        ItemStack stack = this.inventory.getStackInSlot(0);
        AltarCraftingHelper.Ranking reranking = AltarCraftingHelper.rankRecipe(this.recipe, stack, (IItemHandlerModifiable)this.spiritInventory, AltarCraftingHelper.createPedestalInventoryCapture(pedestalItems), (IItemHandlerModifiable)this.extrasInventory);
        if (!Objects.equals(reranking, this.possibleRecipes.get((Object)this.recipe))) {
            this.recalculateRecipes();
            return false;
        }
        SizedIngredient nextIngredient = AltarCraftingHelper.getNextIngredientToTake(this.recipe, (IItemHandlerModifiable)this.extrasInventory);
        if (nextIngredient != null) {
            for (IMalumSpecialItemAccessPoint provider : pedestalItems) {
                LodestoneBlockEntityInventory inventoryForAltar = provider.getSuppliedInventory();
                ItemStack providedStack = inventoryForAltar.extractItem(0, nextIngredient.count(), true);
                if (!nextIngredient.ingredient().test(providedStack)) continue;
                level.playSound(null, provider.getAccessPointBlockPos(), (SoundEvent)MalumSoundEvents.ALTAR_CONSUME.get(), SoundSource.BLOCKS, 1.0f, 1.1f + level.random.nextFloat() * 0.5f);
                MalumParticleEffectTypes.SPIRIT_ALTAR_EATS_ITEM.createEffect(this.worldPosition).color(MalumNetworkedParticleEffectColorData.fromSpiritIngredients(this.recipe.spirits)).customData(new SpiritAltarEatItemParticleEffect.SpiritAltarEatItemEffectData(provider.getAccessPointBlockPos(), providedStack)).spawn(level);
                this.extrasInventory.insertItem(inventoryForAltar.extractItem(0, nextIngredient.count(), false));
                BlockStateHelper.updateAndNotifyState((Level)level, (BlockPos)provider.getAccessPointBlockPos());
                break;
            }
            this.progress = (int)((float)this.progress * 0.8f);
            if (this.extrasInventory.isEmpty()) {
                return false;
            }
            return AltarCraftingHelper.extractIngredient((IItemHandler)this.extrasInventory, (Predicate<ItemStack>)nextIngredient.ingredient(), nextIngredient.count(), true).isEmpty();
        }
        return true;
    }

    public void craft(ServerLevel level) {
        ItemStack stack = this.inventory.getStackInSlot(0);
        ItemStack outputStack = this.recipe.getOutput(level, stack);
        Vec3 itemPos = this.getItemPos();
        this.extrasInventory.clear();
        this.progress -= (int)((float)this.progress * 0.2f);
        stack.shrink(this.recipe.ingredient.count());
        level.addFreshEntity((Entity)new ItemEntity((Level)level, itemPos.x, itemPos.y, itemPos.z, outputStack));
        block0: for (SpiritIngredient spirit : this.recipe.spirits) {
            for (int i = 0; i < this.spiritInventory.slotCount; ++i) {
                ItemStack spiritStack = this.spiritInventory.getStackInSlot(i);
                if (!spirit.test(spiritStack)) continue;
                spiritStack.shrink(spirit.getCount());
                continue block0;
            }
        }
        MalumParticleEffectTypes.SPIRIT_ALTAR_CRAFTS.createEffect(this.worldPosition).color(MalumNetworkedParticleEffectColorData.fromSpiritIngredients(this.recipe.spirits)).spawn(level);
        level.playSound(null, this.worldPosition, (SoundEvent)MalumSoundEvents.ALTAR_CRAFT.get(), SoundSource.BLOCKS, 1.0f, 0.9f + level.random.nextFloat() * 0.2f);
        this.recalibrateAccelerators();
        this.recalculateRecipes();
        BlockStateHelper.updateAndNotifyState((Level)level, (BlockPos)this.worldPosition);
    }

    public void recalibrateAccelerators() {
        this.speed = 1.0f;
        this.accelerators.clear();
        this.acceleratorPositions.clear();
        Collection nearbyAccelerators = BlockEntityHelper.getBlockEntities(IAltarAccelerator.class, (Level)this.level, (BlockPos)this.worldPosition, (int)4, (int)3, (int)4);
        HashMap<IAltarAccelerator.AltarAcceleratorType, Integer> entries = new HashMap<IAltarAccelerator.AltarAcceleratorType, Integer>();
        for (IAltarAccelerator accelerator : nearbyAccelerators) {
            if (!accelerator.canAccelerate()) continue;
            int max = accelerator.getAcceleratorType().maximumEntries();
            int amount = entries.computeIfAbsent(accelerator.getAcceleratorType(), a -> 0);
            if (amount >= max) continue;
            this.accelerators.add(accelerator);
            this.acceleratorPositions.add(((BlockEntity)accelerator).getBlockPos());
            this.speed += accelerator.getAcceleration();
            entries.replace(accelerator.getAcceleratorType(), amount + 1);
        }
    }

    public Vec3 getCentralItemOffset() {
        return ALTAR_ITEM_OFFSET;
    }

    public Vec3 getItemPos() {
        BlockPos blockPos = this.getBlockPos();
        Vec3 offset = this.getCentralItemOffset();
        return new Vec3((double)blockPos.getX() + offset.x, (double)blockPos.getY() + offset.y, (double)blockPos.getZ() + offset.z);
    }

    public Vec3 getSpiritItemOffset(int slot, float partialTicks) {
        float projectedSpiritSpin = this.spiritSpin + this.getSpinUp(Easing.SINE_IN_OUT) * 0.05f + this.speed * 0.5f;
        float lerpSpiritSpin = this.spiritSpin + partialTicks * (projectedSpiritSpin - this.spiritSpin);
        float distanceOscillation = Mth.sin((float)(lerpSpiritSpin / 20.0f % 6.28f)) * 0.025f;
        float distance = 1.0f - this.getSpinUp(Easing.SINE_OUT) * 0.25f + distanceOscillation;
        float height = 0.75f + this.getSpinUp(Easing.QUARTIC_OUT) * this.getSpinUp((Easing)Easing.BACK_OUT) * 0.5f;
        return VecHelper.rotatingRadialOffset((Vec3)new Vec3(0.5, (double)height, 0.5), (float)distance, (float)slot, (float)this.spiritAmount, (float)lerpSpiritSpin, (float)360.0f);
    }

    public float getSpinUp(Easing easing) {
        if (this.warmupTimer > 30.0f) {
            return 1.0f;
        }
        return easing.ease(this.warmupTimer / 30.0f, 0.0f, 1.0f, 1.0f);
    }
}

