/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.screen.codex.screens;

import com.mojang.blaze3d.vertex.PoseStack;
import com.sammy.malum.MalumMod;
import com.sammy.malum.client.VoidRevelationHandler;
import com.sammy.malum.client.screen.codex.BookEntry;
import com.sammy.malum.client.screen.codex.BookWidgetStyle;
import com.sammy.malum.client.screen.codex.PlacedBookEntry;
import com.sammy.malum.client.screen.codex.objects.BookObject;
import com.sammy.malum.client.screen.codex.objects.progression.IconObject;
import com.sammy.malum.client.screen.codex.objects.progression.ScreenOpenerObject;
import com.sammy.malum.client.screen.codex.pages.BookPage;
import com.sammy.malum.client.screen.codex.pages.CyclingPage;
import com.sammy.malum.client.screen.codex.pages.EntryReference;
import com.sammy.malum.client.screen.codex.pages.EntrySelectorPage;
import com.sammy.malum.client.screen.codex.pages.recipe.RuneworkingPage;
import com.sammy.malum.client.screen.codex.pages.recipe.SoulBindingPage;
import com.sammy.malum.client.screen.codex.pages.recipe.SpiritInfusionPage;
import com.sammy.malum.client.screen.codex.pages.recipe.vanilla.CraftingPage;
import com.sammy.malum.client.screen.codex.pages.text.GeasInfoPage;
import com.sammy.malum.client.screen.codex.pages.text.HeadlineTextPage;
import com.sammy.malum.client.screen.codex.pages.text.TextPage;
import com.sammy.malum.client.screen.codex.pages.text.WeepingWellTextPage;
import com.sammy.malum.client.screen.codex.screens.AbstractProgressionCodexScreen;
import com.sammy.malum.client.screen.codex.screens.ArcanaProgressionScreen;
import com.sammy.malum.common.item.codex.EncyclopediaEsotericaItem;
import com.sammy.malum.core.systems.events.SetupMalumCodexEntriesEvent;
import com.sammy.malum.core.systems.geas.GeasEffectType;
import com.sammy.malum.registry.common.MalumGeasEffectTypes;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.item.MalumItems;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

public class VoidProgressionScreen
extends AbstractProgressionCodexScreen {
    public static final ResourceLocation BACKGROUND_TEXTURE = MalumMod.malumPath("textures/gui/book/void_background.png");
    public static VoidProgressionScreen screen;
    public static final List<PlacedBookEntry> VOID_ENTRIES;

    protected VoidProgressionScreen() {
        super((Supplier<SoundEvent>)MalumSoundEvents.ARCANA_SWEETENER_EVIL, 1024, 768);
        this.minecraft = Minecraft.getInstance();
        this.setupEntries();
        NeoForge.EVENT_BUS.post((Event)new SetupMalumCodexEntriesEvent());
        this.setupObjects();
    }

    @Override
    public void renderBackground(PoseStack poseStack) {
        this.renderBackground(poseStack, BACKGROUND_TEXTURE, 0.2f, 0.2f);
    }

    @Override
    public Collection<PlacedBookEntry> getEntries() {
        return VOID_ENTRIES;
    }

    public static VoidProgressionScreen getScreenInstance() {
        if (screen == null) {
            screen = new VoidProgressionScreen();
        }
        return screen;
    }

    public static void openCodexViaItem() {
        VoidProgressionScreen.getScreenInstance().openScreen(true);
        screen.playSweetenedSound((Supplier<SoundEvent>)MalumSoundEvents.ARCANA_CODEX_OPEN, 1.25f);
    }

    public static void openCodexViaTransition() {
        VoidProgressionScreen.getScreenInstance().openScreen(false);
        screen.faceObject((BookObject)VoidProgressionScreen.screen.bookObjectHandler.get(0));
        screen.playSound((Supplier<SoundEvent>)MalumSoundEvents.ARCANA_TRANSITION_EVIL, 1.25f, 1.0f);
        ++VoidProgressionScreen.screen.timesTransitioned;
        VoidProgressionScreen.screen.transitionTimer = screen.getTransitionDuration();
        EncyclopediaEsotericaItem.shouldOpenVoidCodex = true;
        VoidRevelationHandler.seeTheRevelation(VoidRevelationHandler.RevelationType.VOID_READER);
    }

    public void setupEntries() {
        Item EMPTY = ItemStack.EMPTY.getItem();
        BookPage.isVoidThemed = true;
        this.addEntry("chronicles_of_the_soul", 0, 0, b -> b.setWidgetSupplier((e, x, y) -> new ScreenOpenerObject(e, x, y, ArcanaProgressionScreen::openCodexViaTransition, MalumMod.malumPath("textures/gui/book/icons/arcana_button.png"), 20, 20)).configureWidget(w -> w.setStyle(BookWidgetStyle.DARK_GRAND_SOULWOOD).setHeadlineFormatting(ChatFormatting.YELLOW)));
        this.addEntry("void.the_weeping_well", 0, 1, b -> b.configureWidget(w -> w.setIcon((Supplier<? extends Item>)MalumItems.VOID_DEPOT).setStyle(BookWidgetStyle.GILDED_SOULWOOD)).addPage(new HeadlineTextPage("void.the_weeping_well", "void.the_weeping_well.1")).addPage(new TextPage("void.the_weeping_well.2")).addPage(new TextPage("void.the_weeping_well.3")).addPage(new TextPage("void.the_weeping_well.4")).addPage(new TextPage("void.the_weeping_well.5")).addPage(new TextPage("void.the_weeping_well.6")).addPage(new TextPage("void.the_weeping_well.7")));
        this.addEntry("void.material_study_soulstone", 0, 2, b -> b.configureWidget(w -> w.setIcon((Supplier<? extends Item>)MalumItems.RAW_SOULSTONE).setStyle(BookWidgetStyle.SMALL_SOULWOOD)).addPage(new WeepingWellTextPage("void.material_study_soulstone", "void.material_study_soulstone.1", (Item)MalumItems.RAW_SOULSTONE.get())).addPage(new TextPage("void.material_study_soulstone.2")));
        this.addEntry("void.material_study_null_slate", -2, 3, b -> b.configureWidget(w -> w.setIcon((Supplier<? extends Item>)MalumItems.NULL_SLATE).setStyle(BookWidgetStyle.SOULWOOD)).addPage(new WeepingWellTextPage("void.material_study_null_slate", "void.material_study_null_slate.1", (Item)MalumItems.NULL_SLATE.get())).addPage(new TextPage("void.material_study_null_slate.2")).addReference(new EntryReference((Supplier<? extends Item>)MalumItems.UMBRAL_SPIRIT, BookEntry.build("void.material_study_null_slate.reexamination").addPage(new HeadlineTextPage("void.material_study_null_slate.reexamination", "void.material_study_null_slate.reexamination.1")).addPage(new TextPage("void.material_study_null_slate.reexamination.2")).afterUmbralCrystal())));
        this.addEntry("void.material_study_mnemonic_fragment", -3, 4, b -> b.configureWidget(w -> w.setIcon((Supplier<? extends Item>)MalumItems.MNEMONIC_FRAGMENT).setStyle(BookWidgetStyle.SOULWOOD)).addPage(new WeepingWellTextPage("void.material_study_mnemonic_fragment", "void.material_study_mnemonic_fragment.1", (Item)MalumItems.MNEMONIC_FRAGMENT.get())).addPage(new TextPage("void.material_study_mnemonic_fragment.2")).addReference(new EntryReference((Supplier<? extends Item>)MalumItems.UMBRAL_SPIRIT, BookEntry.build("void.material_study_mnemonic_fragment.reexamination").addPage(new HeadlineTextPage("void.material_study_mnemonic_fragment.reexamination", "void.material_study_mnemonic_fragment.reexamination.1")).afterUmbralCrystal())));
        this.addEntry("void.material_study_void_salts", 0, 3, b -> b.configureWidget(w -> w.setIcon((Supplier<? extends Item>)MalumItems.VOID_SALTS).setStyle(BookWidgetStyle.SOULWOOD)).addPage(new WeepingWellTextPage("void.material_study_void_salts", "void.material_study_void_salts.1", (Item)MalumItems.VOID_SALTS.get())).addPage(new TextPage("void.material_study_void_salts.2")).addReference(new EntryReference((Supplier<? extends Item>)MalumItems.UMBRAL_SPIRIT, BookEntry.build("void.material_study_void_salts.reexamination").addPage(new HeadlineTextPage("void.material_study_void_salts.reexamination", "void.material_study_void_salts.reexamination.1")).afterUmbralCrystal())));
        this.addEntry("void.material_study_malignant_lead", 2, 3, b -> b.configureWidget(w -> w.setIcon((Supplier<? extends Item>)MalumItems.MALIGNANT_LEAD).setStyle(BookWidgetStyle.SOULWOOD)).addPage(new WeepingWellTextPage("void.material_study_malignant_lead", "void.material_study_malignant_lead.1", (Item)MalumItems.MALIGNANT_LEAD.get())).addPage(new TextPage("void.material_study_malignant_lead.2")).addReference(new EntryReference((Supplier<? extends Item>)MalumItems.UMBRAL_SPIRIT, BookEntry.build("void.material_study_malignant_lead.reexamination").addPage(new HeadlineTextPage("void.material_study_malignant_lead.reexamination", "void.material_study_malignant_lead.reexamination.1")).addPage(new TextPage("void.material_study_malignant_lead.reexamination.2")).afterUmbralCrystal())));
        this.addEntry("void.material_study_auric_embers", 3, 4, b -> b.configureWidget(w -> w.setIcon((Supplier<? extends Item>)MalumItems.AURIC_EMBERS).setStyle(BookWidgetStyle.SOULWOOD)).addPage(new WeepingWellTextPage("void.material_study_auric_embers", "void.material_study_auric_embers.1", (Item)MalumItems.AURIC_EMBERS.get())).addPage(new TextPage("void.material_study_auric_embers.2")).addReference(new EntryReference((Supplier<? extends Item>)MalumItems.UMBRAL_SPIRIT, BookEntry.build("void.material_study_auric_embers.reexamination").addPage(new HeadlineTextPage("void.material_study_auric_embers.reexamination", "void.material_study_auric_embers.reexamination.1")).afterUmbralCrystal())));
        this.addEntry("void.catalyst_lobber", 5, 5, b -> b.configureWidget(w -> w.setIcon((Supplier<? extends Item>)MalumItems.CATALYST_LOBBER).setStyle(BookWidgetStyle.SOULWOOD)).addPage(new WeepingWellTextPage("void.catalyst_lobber", "void.catalyst_lobber.1", (Item)MalumItems.CATALYST_LOBBER.get())).addPage(new TextPage("void.catalyst_lobber.2")).addPage(new TextPage("void.catalyst_lobber.3")).addPage(SpiritInfusionPage.fromOutput((Item)MalumItems.CATALYST_LOBBER.get())));
        this.addEntry("void.black_crystal", 0, 5, b -> b.withFragmentEntry(fragment -> fragment.addPage(new WeepingWellTextPage("fragment.void.black_crystal", "fragment.void.black_crystal.1", EMPTY))).configureWidget(w -> w.setIcon((Supplier<? extends Item>)MalumItems.UMBRAL_SPIRIT).setStyle(BookWidgetStyle.GILDED_SOULWOOD)).addPage(new WeepingWellTextPage("void.black_crystal", "void.black_crystal.1", (Item)MalumItems.UMBRAL_SPIRIT.get())).addPage(new TextPage("void.black_crystal.2")).addPage(new TextPage("void.black_crystal.3")).addPage(new TextPage("void.black_crystal.4")).afterUmbralCrystal());
        this.addEntry("void.umbral_arcana", -1, 6, b -> b.withEmptyFragmentEntry(BookWidgetStyle.WITHERED).configureWidget(w -> w.setStyle(BookWidgetStyle.DARK_SOULWOOD)).setWidgetSupplier((e, x, y) -> new IconObject(e, x, y, MalumMod.malumPath("textures/gui/book/icons/umbral_shard.png"))).addPage(new HeadlineTextPage("void.umbral_arcana", "void.umbral_arcana.1")).addPage(new TextPage("void.umbral_arcana.2")).addPage(new TextPage("void.umbral_arcana.3")).addPage(new TextPage("void.umbral_arcana.4")).addPage(new TextPage("void.umbral_arcana.5")).afterUmbralCrystal());
        this.addEntry("void.inverse_and_hybrid_arcana", 0, 7, b -> b.withEmptyFragmentEntry(BookWidgetStyle.SMALL_WITHERED).configureWidget(w -> w.setStyle(BookWidgetStyle.DARK_SOULWOOD)).setWidgetSupplier((e, x, y) -> new IconObject(e, x, y, MalumMod.malumPath("textures/gui/book/icons/umbral_shard.png"))).addPage(new HeadlineTextPage("void.inverse_and_hybrid_arcana", "void.inverse_and_hybrid_arcana.1")).addPage(new TextPage("void.inverse_and_hybrid_arcana.2")).addPage(new TextPage("void.inverse_and_hybrid_arcana.3")).afterUmbralCrystal());
        this.addEntry("void.material_study_arcana", 1, 8, b -> b.withTraceFragmentEntry().configureWidget(w -> w.setStyle(BookWidgetStyle.DARK_SOULWOOD)).setWidgetSupplier((e, x, y) -> new IconObject(e, x, y, MalumMod.malumPath("textures/gui/book/icons/umbral_shard.png"))).addPage(new HeadlineTextPage("void.material_study_arcana", "void.material_study_arcana.1")).addPage(new TextPage("void.material_study_arcana.2")).addPage(new TextPage("void.material_study_arcana.3")).afterUmbralCrystal());
        this.addEntry("void.staves_as_foci", 0, 9, b -> b.withTraceFragmentEntry().configureWidget(w -> w.setIcon((Supplier<? extends Item>)MalumItems.MNEMONIC_HEX_STAFF).setStyle(BookWidgetStyle.GILDED_SOULWOOD)).addPage(new HeadlineTextPage("void.staves_as_foci", "void.staves_as_foci.1")).addPage(new TextPage("void.staves_as_foci.2")).addPage(new TextPage("void.staves_as_foci.3")).addPage(new TextPage("void.staves_as_foci.4")).addPage(new TextPage("void.staves_as_foci.5")).addPage(SpiritInfusionPage.fromOutput((Item)MalumItems.MNEMONIC_HEX_STAFF.get())).addReference(new EntryReference(Items.ENCHANTED_BOOK, BookEntry.build("void.staves_as_foci.enchanting").addPage(new HeadlineTextPage("void.staves_as_foci.enchanting.replenishing", "void.staves_as_foci.enchanting.replenishing.1")).addPage(new HeadlineTextPage("void.staves_as_foci.enchanting.capacitor", "void.staves_as_foci.enchanting.capacitor.1")))).addReference(new EntryReference((Supplier<? extends Item>)MalumItems.RING_OF_THE_ENDLESS_WELL, BookEntry.build("void.staves_as_foci.ring_of_the_endless_well").addPage(new HeadlineTextPage("void.staves_as_foci.ring_of_the_endless_well", "void.staves_as_foci.ring_of_the_endless_well.1")).addPage(SpiritInfusionPage.fromOutput((Item)MalumItems.RING_OF_THE_ENDLESS_WELL.get())))).afterUmbralCrystal());
        VoidProgressionScreen.addGeasEntry(this, MalumGeasEffectTypes.OATH_OF_THE_OVERKEEN_EYE, -7, 13);
        VoidProgressionScreen.addGeasEntry(this, MalumGeasEffectTypes.OATH_OF_THE_OVERBURDENED_MIND, -8, 14);
        VoidProgressionScreen.addGeasEntry(this, MalumGeasEffectTypes.OATH_OF_THE_OVEREAGER_FIST, -7, 15);
        VoidProgressionScreen.addGeasEntry(this, MalumGeasEffectTypes.OATH_OF_UNMAKERS_DISDAIN, 7, 13);
        VoidProgressionScreen.addGeasEntry(this, MalumGeasEffectTypes.OATH_OF_UNSIGHTED_RESISTANCE, 8, 14);
        VoidProgressionScreen.addGeasEntry(this, MalumGeasEffectTypes.OATH_OF_THE_UNDISCERNED_MAW, 7, 15);
        this.addEntry("void.ring_of_gruesome_concentration", -3, 9, b -> b.withTraceFragmentEntry().configureWidget(w -> w.setIcon((Supplier<? extends Item>)MalumItems.RING_OF_GRUESOME_CONCENTRATION).setStyle(BookWidgetStyle.SOULWOOD)).addPage(new HeadlineTextPage("void.ring_of_gruesome_concentration", "void.ring_of_gruesome_concentration.1")).addPage(SpiritInfusionPage.fromOutput((Item)MalumItems.RING_OF_GRUESOME_CONCENTRATION.get())).afterUmbralCrystal());
        this.addEntry("void.ring_of_growing_flesh", -4, 10, b -> b.configureWidget(w -> w.setIcon((Supplier<? extends Item>)MalumItems.RING_OF_GROWING_FLESH).setStyle(BookWidgetStyle.SOULWOOD)).addPage(new HeadlineTextPage("void.ring_of_growing_flesh", "void.ring_of_growing_flesh.1")).addPage(SpiritInfusionPage.fromOutput((Item)MalumItems.RING_OF_GROWING_FLESH.get())).afterUmbralCrystal());
        this.addEntry("void.ring_of_echoing_arcana", -5, 10, b -> b.configureWidget(w -> w.setIcon((Supplier<? extends Item>)MalumItems.RING_OF_ECHOING_ARCANA).setStyle(BookWidgetStyle.SOULWOOD)).addPage(new HeadlineTextPage("void.ring_of_echoing_arcana", "void.ring_of_echoing_arcana.1")).addPage(SpiritInfusionPage.fromOutput((Item)MalumItems.RING_OF_ECHOING_ARCANA.get())).afterUmbralCrystal());
        this.addEntry("void.necklace_of_the_watcher", -3, 11, b -> b.configureWidget(w -> w.setIcon((Supplier<? extends Item>)MalumItems.NECKLACE_OF_THE_WATCHER).setStyle(BookWidgetStyle.SOULWOOD)).addPage(new HeadlineTextPage("void.necklace_of_the_watcher", "void.necklace_of_the_watcher.1")).addPage(SpiritInfusionPage.fromOutput((Item)MalumItems.NECKLACE_OF_THE_WATCHER.get())).afterUmbralCrystal());
        this.addEntry("void.necklace_of_the_hidden_blade", -4, 12, b -> b.configureWidget(w -> w.setIcon((Supplier<? extends Item>)MalumItems.NECKLACE_OF_THE_HIDDEN_BLADE).setStyle(BookWidgetStyle.SOULWOOD)).addPage(new HeadlineTextPage("void.necklace_of_the_hidden_blade", "void.necklace_of_the_hidden_blade.1")).addPage(SpiritInfusionPage.fromOutput((Item)MalumItems.NECKLACE_OF_THE_HIDDEN_BLADE.get())).addPage(new TextPage("void.necklace_of_the_hidden_blade.2")).addPage(new TextPage("void.necklace_of_the_hidden_blade.3")).afterUmbralCrystal());
        this.addEntry("void.malignant_pewter", 3, 9, b -> b.withTraceFragmentEntry().configureWidget(w -> w.setIcon((Supplier<? extends Item>)MalumItems.MALIGNANT_PEWTER_INGOT).setStyle(BookWidgetStyle.SOULWOOD)).addPage(new HeadlineTextPage("void.malignant_pewter", "void.malignant_pewter.1")).addPage(SpiritInfusionPage.fromOutput((Item)MalumItems.MALIGNANT_PEWTER_INGOT.get())).addPage(new TextPage("void.malignant_pewter.2")).addPage(new TextPage("void.malignant_pewter.3")).afterUmbralCrystal());
        this.addEntry("void.weight_of_worlds", 4, 10, b -> b.configureWidget(w -> w.setIcon((Supplier<? extends Item>)MalumItems.WEIGHT_OF_WORLDS).setStyle(BookWidgetStyle.SOULWOOD)).addPage(new HeadlineTextPage("void.weight_of_worlds", "void.weight_of_worlds.1")).addPage(SpiritInfusionPage.fromOutput((Item)MalumItems.WEIGHT_OF_WORLDS.get())).addPage(new TextPage("void.weight_of_worlds.2")).afterUmbralCrystal());
        this.addEntry("void.edge_of_deliverance", 5, 10, b -> b.configureWidget(w -> w.setIcon((Supplier<? extends Item>)MalumItems.EDGE_OF_DELIVERANCE).setStyle(BookWidgetStyle.SOULWOOD)).addPage(new HeadlineTextPage("void.edge_of_deliverance", "void.edge_of_deliverance.1")).addPage(SpiritInfusionPage.fromOutput((Item)MalumItems.EDGE_OF_DELIVERANCE.get())).addPage(new TextPage("void.edge_of_deliverance.2")).afterUmbralCrystal());
        this.addEntry("void.erosion_scepter", 3, 11, b -> b.configureWidget(w -> w.setIcon((Supplier<? extends Item>)MalumItems.EROSION_SCEPTER).setStyle(BookWidgetStyle.SOULWOOD)).addPage(new HeadlineTextPage("void.erosion_scepter", "void.erosion_scepter.1")).addPage(SpiritInfusionPage.fromOutput((Item)MalumItems.EROSION_SCEPTER.get())).addPage(new TextPage("void.erosion_scepter.2")).addPage(new TextPage("void.erosion_scepter.3")).addPage(new TextPage("void.erosion_scepter.4")).afterUmbralCrystal());
        this.addEntry("void.malignant_stronghold_armor", 4, 12, b -> b.configureWidget(w -> w.setIcon((Supplier<? extends Item>)MalumItems.MALIGNANT_STRONGHOLD_HELMET).setStyle(BookWidgetStyle.SOULWOOD)).addPage(new HeadlineTextPage("void.malignant_stronghold_armor", "void.malignant_stronghold_armor.1")).addPage(new TextPage("void.malignant_stronghold_armor.2")).addPage(new CyclingPage(SpiritInfusionPage.fromOutput((Item)MalumItems.MALIGNANT_STRONGHOLD_HELMET.get()), SpiritInfusionPage.fromOutput((Item)MalumItems.MALIGNANT_STRONGHOLD_CHESTPLATE.get()), SpiritInfusionPage.fromOutput((Item)MalumItems.MALIGNANT_STRONGHOLD_LEGGINGS.get()), SpiritInfusionPage.fromOutput((Item)MalumItems.MALIGNANT_STRONGHOLD_BOOTS.get()))).addPage(new CraftingPage(new ItemStack((ItemLike)MalumItems.MALIGNANT_PEWTER_PLATING.get(), 2), EMPTY, (Item)MalumItems.MALIGNANT_PEWTER_NUGGET.get(), EMPTY, (Item)MalumItems.MALIGNANT_PEWTER_NUGGET.get(), (Item)MalumItems.MALIGNANT_PEWTER_INGOT.get(), (Item)MalumItems.MALIGNANT_PEWTER_NUGGET.get(), EMPTY, (Item)MalumItems.MALIGNANT_PEWTER_NUGGET.get(), EMPTY)).afterUmbralCrystal());
        this.addEntry("void.runes", 0, 11, b -> b.configureWidget(w -> w.setIcon((Supplier<? extends Item>)MalumItems.RUNE_OF_HERESY).setStyle(BookWidgetStyle.SOULWOOD)).addPage(new HeadlineTextPage("void.runes", "void.runes.1")).addPage(new EntrySelectorPage(item -> {
            String translationKey = "void." + BuiltInRegistries.ITEM.getKey(item).getPath();
            return new EntryReference((Item)item, BookEntry.build(translationKey).addPage(new HeadlineTextPage(translationKey)).addPage(RuneworkingPage.fromOutput(item)));
        }, (Item)MalumItems.RUNE_OF_BOLSTERING.get(), (Item)MalumItems.RUNE_OF_SACRIFICIAL_EMPOWERMENT.get(), (Item)MalumItems.RUNE_OF_SPELL_MASTERY.get(), (Item)MalumItems.RUNE_OF_HERESY.get(), (Item)MalumItems.RUNE_OF_UNNATURAL_STAMINA.get(), (Item)MalumItems.RUNE_OF_TWINNED_DURATION.get(), (Item)MalumItems.RUNE_OF_INDOMITABILITY.get(), (Item)MalumItems.RUNE_OF_IGNEOUS_SOLACE.get())).afterUmbralCrystal());
        this.addEntry("void.fused_consciousness", 0, 15, b -> b.configureWidget(w -> w.setIcon((Supplier<? extends Item>)MalumItems.FUSED_CONSCIOUSNESS).setStyle(BookWidgetStyle.GILDED_SOULWOOD)).addPage(new WeepingWellTextPage("void.fused_consciousness", "void.fused_consciousness.1", (Item)MalumItems.FUSED_CONSCIOUSNESS.get())).addPage(SpiritInfusionPage.fromOutput((Item)MalumItems.COMPLETE_DESIGN.get())).afterUmbralCrystal());
        this.addEntry("void.sundering_anchor", -2, 16, b -> b.configureWidget(w -> w.setIcon((Supplier<? extends Item>)MalumItems.SUNDERING_ANCHOR).setStyle(BookWidgetStyle.TOTEMIC_SOULWOOD)).addPage(new WeepingWellTextPage("void.sundering_anchor", "void.sundering_anchor.1", (Item)MalumItems.SUNDERING_ANCHOR.get())).addPage(new TextPage("void.sundering_anchor.2")).addPage(new TextPage("void.sundering_anchor.3")).addPage(SpiritInfusionPage.fromOutput((Item)MalumItems.SUNDERING_ANCHOR.get())).afterUmbralCrystal());
        this.addEntry("void.unwinding_chaos", 2, 16, b -> b.configureWidget(w -> w.setIcon((Supplier<? extends Item>)MalumItems.UNWINDING_CHAOS).setStyle(BookWidgetStyle.TOTEMIC_SOULWOOD)).addPage(new WeepingWellTextPage("void.unwinding_chaos", "void.unwinding_chaos.1", (Item)MalumItems.UNWINDING_CHAOS.get())).addPage(new TextPage("void.unwinding_chaos.2")).addPage(new TextPage("void.unwinding_chaos.3")).addPage(SpiritInfusionPage.fromOutput((Item)MalumItems.UNWINDING_CHAOS.get())).afterUmbralCrystal());
        this.addEntry("void.belt_of_the_limitless", -3, 17, b -> b.configureWidget(w -> w.setIcon((Supplier<? extends Item>)MalumItems.BELT_OF_THE_LIMITLESS).setStyle(BookWidgetStyle.TOTEMIC_SOULWOOD)).addPage(new WeepingWellTextPage("void.belt_of_the_limitless", "void.belt_of_the_limitless.1", (Item)MalumItems.BELT_OF_THE_LIMITLESS.get())).addPage(new TextPage("void.belt_of_the_limitless.2")).addPage(new TextPage("void.belt_of_the_limitless.3")).addPage(SpiritInfusionPage.fromOutput((Item)MalumItems.BELT_OF_THE_LIMITLESS.get())).afterUmbralCrystal());
        VoidProgressionScreen.addGeasEntry(this, MalumGeasEffectTypes.AUTHORITY_OF_THE_INVERTED_HEART, -2, 18);
        VoidProgressionScreen.addGeasEntry(this, MalumGeasEffectTypes.AUTHORITY_OF_THE_GLEEFUL_TARGET, 2, 18);
        BookPage.isVoidThemed = false;
    }

    public static void addGeasEntry(AbstractProgressionCodexScreen screen, Holder<GeasEffectType> geas, int x, int y) {
        screen.addEntry(((GeasEffectType)geas.value()).getId().getPath(), x, y, b -> b.configureWidget(w -> w.setIcon(geas).setStyle(BookWidgetStyle.DARK_SOULWOOD)).addPage(SoulBindingPage.fromGeas(geas)).addPage(new GeasInfoPage(geas)).afterUmbralCrystal());
    }

    static {
        VOID_ENTRIES = new ArrayList<PlacedBookEntry>();
    }
}

