/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.screen.codex.screens;

import com.sammy.malum.client.screen.codex.ArcanaCodexHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;

public abstract class AbstractMalumScreen
extends Screen {
    protected final Supplier<SoundEvent> sweetenerSound;
    public List<Runnable> lateRendering = new ArrayList<Runnable>();

    protected AbstractMalumScreen(Component pTitle, Supplier<SoundEvent> sweetenerSound) {
        super(pTitle);
        this.sweetenerSound = sweetenerSound;
    }

    public boolean isHovering(double mouseX, double mouseY, float posX, float posY, int width, int height) {
        return ArcanaCodexHelper.isHovering(mouseX, mouseY, posX, posY, width, height);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.minecraft.options.keyInventory.matches(keyCode, scanCode)) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void openScreen(boolean silentMouseInput) {
        Minecraft.getInstance().setScreen((Screen)this);
    }

    public void playPageFlipSound(Supplier<SoundEvent> soundEvent, float pitch) {
        this.playSound(soundEvent, 1.0f, Math.max(1.0f, pitch * 0.8f));
        this.playSound(this.sweetenerSound, 1.0f, pitch);
    }

    public void playSweetenedSound(Supplier<SoundEvent> soundEvent, float sweetenerPitch) {
        this.playSound(soundEvent, 1.0f, 1.0f);
        this.playSound(this.sweetenerSound, 1.0f, sweetenerPitch);
    }

    public void playSound(Supplier<SoundEvent> soundEvent, float volume, float pitch) {
        Minecraft.getInstance().player.playNotifySound(soundEvent.get(), SoundSource.PLAYERS, volume, pitch);
    }

    public void renderLater(Runnable runnable) {
        this.lateRendering.add(runnable);
    }

    protected void doLateRendering() {
        this.lateRendering.forEach(Runnable::run);
        this.lateRendering.clear();
    }
}

