/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.screen.codex.pages.recipe;

import com.sammy.malum.MalumMod;
import com.sammy.malum.client.screen.codex.ArcanaCodexHelper;
import com.sammy.malum.client.screen.codex.pages.BookPage;
import com.sammy.malum.client.screen.codex.screens.AbstractMalumScreen;
import com.sammy.malum.client.screen.codex.screens.EntryScreen;
import com.sammy.malum.common.recipe.SoulBindingRecipe;
import com.sammy.malum.core.systems.geas.GeasEffectType;
import com.sammy.malum.registry.common.recipe.MalumRecipeTypes;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import team.lodestar.lodestone.systems.recipe.LodestoneRecipeType;

public class SoulBindingPage
extends BookPage {
    private static final Component BASE = Component.translatable((String)"malum.gui.book.entry.page.info.soulbinding");
    private static final Component SPIRIT = Component.translatable((String)"malum.gui.book.entry.page.info.soulbinding.spirit");
    private static final Component ITEM = Component.translatable((String)"malum.gui.book.entry.page.info.soulbinding.item");
    private final SoulBindingRecipe recipe;

    public SoulBindingPage(Predicate<SoulBindingRecipe> predicate) {
        this((SoulBindingRecipe)LodestoneRecipeType.findRecipe((Level)Minecraft.getInstance().level, (RecipeType)((RecipeType)MalumRecipeTypes.SOUL_BINDING.get()), predicate));
    }

    public SoulBindingPage(SoulBindingRecipe recipe) {
        super(isVoidThemed ? MalumMod.malumPath("textures/gui/book/pages/soulbinding_page_void.png") : MalumMod.malumPath("textures/gui/book/pages/soulbinding_page.png"));
        this.recipe = recipe;
    }

    public String headlineTranslationKey() {
        return this.recipe.geas.getLangKey();
    }

    @Override
    public void render(EntryScreen screen, GuiGraphics guiGraphics, int left, int top, int mouseX, int mouseY, float partialTicks, boolean isRepeat) {
        ArcanaCodexHelper.renderHeadline(guiGraphics, (Component)Component.translatable((String)this.headlineTranslationKey()), left, top);
        ArcanaCodexHelper.renderItem((AbstractMalumScreen)screen, guiGraphics, this.recipe.geas.createDefaultStack(), left + 63, top + 38, mouseX, mouseY);
        ArcanaCodexHelper.renderIngredient((AbstractMalumScreen)screen, guiGraphics, this.recipe.ingredient, left + 63, top + 87, mouseX, mouseY);
        ArcanaCodexHelper.renderIngredients(screen, guiGraphics, this.recipe.spirits, SPIRIT, left + 13, top + 87, mouseX, mouseY, true);
        if (!this.recipe.extraIngredients.isEmpty()) {
            ArcanaCodexHelper.renderIngredients(screen, guiGraphics, this.recipe.extraIngredients, ITEM, left + 113, top + 87, mouseX, mouseY, true);
        }
        screen.renderLater(() -> {
            if (screen.isHovering(mouseX, mouseY, left + 60, top + 105, 18, 18)) {
                guiGraphics.renderComponentTooltip(Minecraft.getInstance().font, ArcanaCodexHelper.wrapComponent(BASE, 180), mouseX, mouseY);
            }
        });
    }

    @Override
    public boolean isValid() {
        return this.recipe != null;
    }

    public static SoulBindingPage fromGeas(Holder<GeasEffectType> geasEffectType) {
        return new SoulBindingPage(s -> s.geas.equals(geasEffectType.value()));
    }
}

