/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.screen.codex.objects.progression;

import com.mojang.blaze3d.vertex.PoseStack;
import com.sammy.malum.client.screen.codex.ArcanaCodexHelper;
import com.sammy.malum.client.screen.codex.BookEntry;
import com.sammy.malum.client.screen.codex.BookWidgetStyle;
import com.sammy.malum.client.screen.codex.objects.BookObject;
import com.sammy.malum.client.screen.codex.pages.EntryReference;
import com.sammy.malum.client.screen.codex.screens.AbstractProgressionCodexScreen;
import com.sammy.malum.client.screen.codex.screens.EntryScreen;
import com.sammy.malum.client.screen.codex.screens.VoidProgressionScreen;
import com.sammy.malum.core.systems.geas.GeasEffectType;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ProgressionEntryObject
extends BookObject<AbstractProgressionCodexScreen> {
    public final BookEntry entry;
    public BookWidgetStyle style = BookWidgetStyle.RUNEWOOD;
    public ChatFormatting headlineFormatting;
    public Predicate<AbstractProgressionCodexScreen> isValid = t -> true;
    public ItemStack iconStack;

    public ProgressionEntryObject(BookEntry entry, int posX, int posY) {
        super(posX, posY, 32, 32);
        this.entry = entry;
    }

    @Override
    public boolean isValid(AbstractProgressionCodexScreen screen) {
        return this.isValid.test(screen) && this.entry.shouldShow();
    }

    @Override
    public void click(AbstractProgressionCodexScreen screen, double mouseX, double mouseY) {
        if (this.entry.hasContents()) {
            EntryScreen.openScreen(screen, this);
        }
    }

    @Override
    public void render(AbstractProgressionCodexScreen screen, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        PoseStack poseStack = guiGraphics.pose();
        int posX = this.getOffsetXPosition() - (this.style.textureWidth() - 32) / 2;
        int posY = this.getOffsetYPosition() - (this.style.textureHeight() - 32) / 2;
        int centerX = posX + this.style.textureWidth() / 2;
        int centerY = posY + this.style.textureHeight() / 2;
        ArcanaCodexHelper.renderTexture(WIDGET_FADE_TEXTURE, poseStack, centerX - 29, centerY - 29, 0.0f, 0.0f, 58, 58);
        ArcanaCodexHelper.renderTexture(this.style.frameTexture(), poseStack, posX, posY, 0.0f, 0.0f, this.style.textureWidth(), this.style.textureHeight());
        ArcanaCodexHelper.renderTexture(this.style.fillingTexture(), poseStack, posX, posY, 0.0f, 0.0f, this.style.textureWidth(), this.style.textureHeight());
        if (this.iconStack != null) {
            guiGraphics.renderItem(this.iconStack, centerX - this.style.itemXOffset(), centerY - this.style.itemYOffset());
        }
    }

    @Override
    public void renderLate(AbstractProgressionCodexScreen screen, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.isHoveredOver && this.entry.hasTooltip()) {
            ChatFormatting formatting = this.getHeadlineStyle(screen);
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>(List.of(ArcanaCodexHelper.convertToComponent(this.entry.translationKey(), this.entry.titleStyle).withStyle(formatting), ArcanaCodexHelper.convertToComponent(this.entry.descriptionTranslationKey(), this.entry.subtitleStyle)));
            for (EntryReference reference : this.entry.references) {
                if (!reference.entry.shouldShow()) continue;
                MutableComponent slash = Component.literal((String)" -").withStyle(reference.entry.subtitleStyle);
                MutableComponent text = slash.append((Component)Component.translatable((String)reference.entry.translationKey()));
                list.add(text.setStyle(Style.EMPTY.withColor(ChatFormatting.DARK_GRAY)));
            }
            guiGraphics.renderComponentTooltip(Minecraft.getInstance().font, list, mouseX, mouseY);
        }
    }

    public ChatFormatting getHeadlineStyle(AbstractProgressionCodexScreen screen) {
        ChatFormatting formatting;
        if (this.headlineFormatting != null) {
            return this.headlineFormatting;
        }
        ChatFormatting chatFormatting = formatting = screen instanceof VoidProgressionScreen ? ChatFormatting.DARK_PURPLE : ChatFormatting.GOLD;
        if (this.style.equals(BookWidgetStyle.GILDED_RUNEWOOD) || this.style.equals(BookWidgetStyle.GILDED_SOULWOOD)) {
            formatting = screen instanceof VoidProgressionScreen ? ChatFormatting.LIGHT_PURPLE : ChatFormatting.YELLOW;
        }
        return formatting;
    }

    public ProgressionEntryObject setIcon(Supplier<? extends Item> item) {
        return this.setIcon(item.get());
    }

    public ProgressionEntryObject setIcon(Item item) {
        return this.setIcon(item.getDefaultInstance());
    }

    public ProgressionEntryObject setIcon(Holder<GeasEffectType> geas) {
        return this.setIcon(((GeasEffectType)geas.value()).createDefaultStack());
    }

    public ProgressionEntryObject setIcon(ItemStack itemStack) {
        this.iconStack = itemStack;
        return this;
    }

    public ProgressionEntryObject setStyle(BookWidgetStyle style) {
        this.style = style;
        return this;
    }

    public ProgressionEntryObject setHeadlineFormatting(ChatFormatting formatting) {
        this.headlineFormatting = formatting;
        return this;
    }

    public ProgressionEntryObject setValidityChecker(Predicate<AbstractProgressionCodexScreen> isValid) {
        this.isValid = isValid;
        return this;
    }
}

