/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.renderer.block.artifice;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.sammy.malum.client.renderer.block.artifice.ArtificeAcceptorRenderer;
import com.sammy.malum.client.renderer.entity.FloatingItemEntityRenderer;
import com.sammy.malum.common.block.curiosities.spirit_crucible.SpiritCrucibleCoreBlockEntity;
import com.sammy.malum.common.item.augment.AugmentItem;
import com.sammy.malum.common.item.spirit.SpiritShardItem;
import com.sammy.malum.core.systems.artifice.ArtificeAttributeData;
import com.sammy.malum.core.systems.artifice.ArtificeAttributeType;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import team.lodestar.lodestone.handlers.RenderHandler;
import team.lodestar.lodestone.helpers.ColorHelper;
import team.lodestar.lodestone.registry.client.LodestoneRenderTypes;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntityInventory;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.rendering.LodestoneBufferWrapper;

public class SpiritCrucibleRenderer
extends ArtificeAcceptorRenderer<SpiritCrucibleCoreBlockEntity> {
    private static final MultiBufferSource TEXT = new LodestoneBufferWrapper(LodestoneRenderTypes.ADDITIVE_TEXT, (MultiBufferSource)RenderHandler.DELAYED_RENDER.getTarget());

    public SpiritCrucibleRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(SpiritCrucibleCoreBlockEntity blockEntityIn, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        Vec3 offset;
        ItemStack stack;
        SpiritCrucibleRenderer.renderModifiers(blockEntityIn, partialTicks, poseStack, bufferIn, combinedLightIn, combinedOverlayIn);
        ClientLevel level = Minecraft.getInstance().level;
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        LodestoneBlockEntityInventory inventory = blockEntityIn.spiritInventory;
        int spiritsRendered = 0;
        if (!inventory.isEmpty()) {
            for (int i = 0; i < inventory.slotCount; ++i) {
                ItemStack item = inventory.getStackInSlot(i);
                Item item2 = item.getItem();
                if (!(item2 instanceof SpiritShardItem)) continue;
                SpiritShardItem shardItem = (SpiritShardItem)item2;
                poseStack.pushPose();
                Vector3f offset2 = blockEntityIn.getSpiritItemOffset(spiritsRendered++, partialTicks).toVector3f();
                poseStack.translate(offset2.x(), offset2.y(), offset2.z());
                FloatingItemEntityRenderer.renderSpiritGlimmer(poseStack, shardItem.type, partialTicks);
                poseStack.mulPose(Axis.YP.rotationDegrees(((float)(level.getGameTime() % 360L) + partialTicks) * 3.0f));
                poseStack.scale(0.5f, 0.5f, 0.5f);
                itemRenderer.renderStatic(item, ItemDisplayContext.FIXED, combinedLightIn, OverlayTexture.NO_OVERLAY, poseStack, bufferIn, (Level)level, 0);
                poseStack.popPose();
            }
        }
        if (!(stack = blockEntityIn.inventory.getStackInSlot(0)).isEmpty()) {
            poseStack.pushPose();
            offset = SpiritCrucibleCoreBlockEntity.CRUCIBLE_ITEM_OFFSET;
            poseStack.translate(offset.x + 0.5, offset.y + 0.5, offset.z + 0.5);
            poseStack.mulPose(Axis.YP.rotationDegrees(((float)(level.getGameTime() % 360L) + partialTicks) * 3.0f));
            poseStack.scale(0.45f, 0.45f, 0.45f);
            itemRenderer.renderStatic(stack, ItemDisplayContext.FIXED, combinedLightIn, OverlayTexture.NO_OVERLAY, poseStack, bufferIn, (Level)level, 0);
            poseStack.popPose();
        }
        if (!(stack = blockEntityIn.coreAugmentInventory.getStackInSlot(0)).isEmpty()) {
            poseStack.pushPose();
            offset = SpiritCrucibleCoreBlockEntity.CRUCIBLE_CORE_AUGMENT_OFFSET;
            poseStack.translate(offset.x + 0.5, offset.y + 0.5, offset.z + 0.5);
            poseStack.mulPose(Axis.YP.rotationDegrees(((float)(-level.getGameTime() % 360L) - partialTicks) * 3.0f));
            poseStack.scale(0.45f, 0.45f, 0.45f);
            itemRenderer.renderStatic(stack, ItemDisplayContext.FIXED, combinedLightIn, OverlayTexture.NO_OVERLAY, poseStack, bufferIn, (Level)level, 0);
            poseStack.popPose();
        }
        LodestoneBlockEntityInventory augmentInventory = blockEntityIn.augmentInventory;
        int augmentsRendered = 0;
        if (!augmentInventory.isEmpty()) {
            float total = augmentInventory.slotCount;
            float time = 240.0f;
            int i = 0;
            while ((float)i < total) {
                ItemStack item = augmentInventory.getStackInSlot(i);
                if (item.getItem() instanceof AugmentItem) {
                    double angle = (double)((float)augmentsRendered / total) * (Math.PI * 2);
                    poseStack.pushPose();
                    Vector3f offset3 = blockEntityIn.getAugmentItemOffset(augmentsRendered++, partialTicks).toVector3f();
                    poseStack.translate(offset3.x(), offset3.y(), offset3.z());
                    poseStack.mulPose(Axis.YP.rotation((float)(angle -= (double)((float)((long)(blockEntityIn.spiritSpin + partialTicks)) % time / time) * (Math.PI * 2)) - (i % 2 == 0 ? 4.71f : 1.57f)));
                    poseStack.scale(0.5f, 0.5f, 0.5f);
                    itemRenderer.renderStatic(item, ItemDisplayContext.FIXED, combinedLightIn, OverlayTexture.NO_OVERLAY, poseStack, bufferIn, (Level)level, 0);
                    poseStack.popPose();
                }
                ++i;
            }
        }
        if (FORK_TRACKER.isVisible()) {
            ArtificeAttributeData accelerationData = blockEntityIn.getAttributes();
            List<ArtificeAttributeType> attributes = accelerationData.getExistingAttributesForTuning();
            Font font = Minecraft.getInstance().font;
            float scalar = Easing.SINE_IN_OUT.ease(FORK_TRACKER.getDelta(partialTicks), 0.0f, 1.0f);
            float scale = 0.016f - (1.0f - scalar) * 0.004f;
            poseStack.pushPose();
            poseStack.translate(0.5f, 2.0f, 0.55f);
            poseStack.mulPose(Minecraft.getInstance().getEntityRenderDispatcher().cameraOrientation());
            for (int i = 0; i < attributes.size(); ++i) {
                ArtificeAttributeType attributeType = attributes.get(i);
                String dataPrint = attributeType.getDataPrint(accelerationData);
                boolean important = attributeType.equals(accelerationData.tunedAttribute);
                MutableComponent dataText = Component.literal((String)(" <" + dataPrint + ">"));
                MutableComponent text = Component.translatable((String)attributeType.getLangKey());
                MutableComponent outlineText = Component.translatable((String)attributeType.getLangKey());
                if (important) {
                    dataText.withStyle(ChatFormatting.BOLD);
                    text = Component.literal((String)"[").append((Component)text).append((Component)Component.literal((String)"]")).withStyle(ChatFormatting.BOLD);
                    outlineText = Component.literal((String)"[").append((Component)outlineText).append((Component)Component.literal((String)"]")).withStyle(ChatFormatting.BOLD);
                }
                text.append((Component)dataText).withStyle(ChatFormatting.AQUA);
                outlineText.append((Component)dataText).withStyle(ChatFormatting.LIGHT_PURPLE);
                float f = (float)(-font.width((FormattedText)text)) / 2.0f;
                float xPos = 0.0f + f;
                poseStack.pushPose();
                poseStack.translate(0.0f, (float)i * 0.15f, 0.0f);
                poseStack.scale(scale, -scale, -scale);
                Matrix4f pose = poseStack.last().pose();
                float alpha = 0.38f * scalar;
                int color = ColorHelper.getColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                if ((double)alpha > 0.02) {
                    SpiritCrucibleRenderer.renderText(text, xPos, 0.0f, color, pose);
                }
                if ((double)(alpha = 0.18f * scalar) > 0.02) {
                    color = ColorHelper.getColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                    SpiritCrucibleRenderer.renderText(text, xPos - 0.5f, 0.0f, color, pose);
                    SpiritCrucibleRenderer.renderText(text, xPos - 0.5f, 0.0f, color, pose);
                    SpiritCrucibleRenderer.renderText(text, xPos, 0.5f, color, pose);
                    SpiritCrucibleRenderer.renderText(text, xPos, -0.5f, color, pose);
                }
                if ((double)(alpha = 0.12f * scalar) > 0.02) {
                    color = ColorHelper.getColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                    SpiritCrucibleRenderer.renderText(text, xPos - 1.0f, 0.0f, color, pose);
                    SpiritCrucibleRenderer.renderText(outlineText, xPos + 1.0f, 0.0f, color, pose);
                    SpiritCrucibleRenderer.renderText(outlineText, xPos, 1.0f, color, pose);
                    SpiritCrucibleRenderer.renderText(text, xPos, -1.0f, color, pose);
                    SpiritCrucibleRenderer.renderText(outlineText, xPos - 0.5f, -0.5f, color, pose);
                    SpiritCrucibleRenderer.renderText(text, xPos - 0.5f, 0.5f, color, pose);
                    SpiritCrucibleRenderer.renderText(outlineText, xPos + 0.5f, 0.5f, color, pose);
                    SpiritCrucibleRenderer.renderText(text, xPos + 0.5f, -0.5f, color, pose);
                }
                poseStack.popPose();
            }
            poseStack.popPose();
        }
    }

    public static void renderText(MutableComponent component, float xPos, float yPos, int color, Matrix4f pose) {
        Font font = Minecraft.getInstance().font;
        font.drawInBatch((Component)component, xPos, yPos, color, false, pose, TEXT, Font.DisplayMode.NORMAL, 0, 0xF000F0);
    }

    public AABB getRenderBoundingBox(SpiritCrucibleCoreBlockEntity blockEntity) {
        BlockPos pos = blockEntity.getBlockPos();
        return new AABB((double)(pos.getX() - 1), (double)pos.getY(), (double)(pos.getZ() - 1), (double)(pos.getX() + 1), (double)(pos.getY() + 4), (double)(pos.getZ() + 1));
    }
}

