/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.extensions;

import com.sammy.malum.client.extensions.ArmorClientItemExtensions;
import com.sammy.malum.client.scarf.ScarfRenderHandler;
import com.sammy.malum.common.data.component.ItemSkinComponent;
import com.sammy.malum.config.ClientConfig;
import com.sammy.malum.registry.client.MalumRenderTypeTokens;
import com.sammy.malum.registry.common.item.MalumDataComponents;
import java.awt.Color;
import java.util.function.Supplier;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import team.lodestar.lodestone.systems.model.LodestoneArmorModel;
import team.lodestar.lodestone.systems.rendering.rendeertype.RenderTypeToken;

public class MalignantArmorItemExtensions
extends ArmorClientItemExtensions {
    public MalignantArmorItemExtensions(Supplier<LodestoneArmorModel> model) {
        super(model);
    }

    @Override
    public LodestoneArmorModel getHumanoidArmorModel(LivingEntity entity, ItemStack itemStack, EquipmentSlot armorSlot, HumanoidModel _default) {
        LodestoneArmorModel model = super.getHumanoidArmorModel(entity, itemStack, armorSlot, _default);
        if (armorSlot.equals((Object)EquipmentSlot.CHEST)) {
            ItemSkinComponent skin = (ItemSkinComponent)itemStack.get(MalumDataComponents.APPLIED_ITEM_SKIN);
            RenderTypeToken scarfToken = skin != null ? RenderTypeToken.createToken((ResourceLocation)skin.name().withPrefix("textures/vfx/scarf/").withSuffix(".png")) : MalumRenderTypeTokens.SCARF;
            ScarfRenderHandler.addScarfRenderer(entity, l -> {
                ScarfRenderHandler.ScarfRenderData data = new ScarfRenderHandler.ScarfRenderData(scarfToken, (Integer)ClientConfig.SCARF_LENGTH.getConfigValue()).setPredicate(() -> entity.getItemBySlot(armorSlot).is(itemStack.getItem())).setScale(0.4f);
                if (skin == null) {
                    data.setPrimaryColor(new Color(183, 45, 69)).setSecondaryColor(new Color(126, 25, 95));
                }
                return data;
            });
        }
        return model;
    }
}

