/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.ChunkPos;

public class MutableChunkPos
extends ChunkPos {
    private int mutableX;
    private int mutableZ;

    public MutableChunkPos(int x, int z) {
        super(x, z);
        this.mutableX = x;
        this.mutableZ = z;
    }

    public MutableChunkPos(BlockPos pos) {
        super(pos);
        this.mutableX = pos.getX() >> 4;
        this.mutableZ = pos.getZ() >> 4;
    }

    public MutableChunkPos(long longIn) {
        super(longIn);
        this.mutableX = (int)longIn;
        this.mutableZ = (int)(longIn >> 32);
    }

    public long toLong() {
        return MutableChunkPos.asLong((int)this.mutableX, (int)this.mutableZ);
    }

    public int hashCode() {
        int i = 1664525 * this.mutableX + 1013904223;
        int j = 1664525 * (this.mutableZ ^ 0xDEADBEEF) + 1013904223;
        return i ^ j;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof MutableChunkPos) {
            MutableChunkPos mcp = (MutableChunkPos)((Object)obj);
            return this.mutableX == mcp.mutableX && this.mutableZ == mcp.mutableZ;
        }
        if (obj instanceof ChunkPos) {
            ChunkPos cp = (ChunkPos)obj;
            return this.mutableX == cp.x && this.mutableZ == cp.z;
        }
        return false;
    }

    public int getMinBlockX() {
        return SectionPos.sectionToBlockCoord((int)this.mutableX);
    }

    public int getMinBlockZ() {
        return SectionPos.sectionToBlockCoord((int)this.mutableZ);
    }

    public int getBlockX(int offset) {
        return SectionPos.sectionToBlockCoord((int)this.mutableX, (int)offset);
    }

    public int getBlockZ(int offset) {
        return SectionPos.sectionToBlockCoord((int)this.mutableZ, (int)offset);
    }

    public int getRegionX() {
        return this.mutableX >> 5;
    }

    public int getRegionZ() {
        return this.mutableZ >> 5;
    }

    public int getRegionLocalX() {
        return this.mutableX & 0x1F;
    }

    public int getRegionLocalZ() {
        return this.mutableZ & 0x1F;
    }

    public String toString() {
        return "[" + this.mutableX + ", " + this.mutableZ + "]";
    }

    public int getChessboardDistance(ChunkPos chunkPosIn) {
        return Math.max(Math.abs(this.mutableX - chunkPosIn.x), Math.abs(this.mutableZ - chunkPosIn.z));
    }

    public int getChessboardDistance(MutableChunkPos chunkPosIn) {
        return Math.max(Math.abs(this.mutableX - chunkPosIn.mutableX), Math.abs(this.mutableZ - chunkPosIn.mutableZ));
    }

    public int getX() {
        return this.mutableX;
    }

    public void setX(int x) {
        this.mutableX = x;
    }

    public int getZ() {
        return this.mutableZ;
    }

    public void setZ(int z) {
        this.mutableZ = z;
    }

    public void from(ChunkPos chunkPos) {
        this.mutableX = chunkPos.x;
        this.mutableZ = chunkPos.z;
    }

    public ChunkPos toImmutable() {
        return new ChunkPos(this.mutableX, this.mutableZ);
    }
}

