/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.util;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.compatibility.IFurnaceRecipes;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.crafting.RecipeStorage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.Nullable;

public class FurnaceRecipes
implements IFurnaceRecipes {
    private Map<ItemStorage, RecipeStorage> recipes = new HashMap<ItemStorage, RecipeStorage>();
    private Map<ItemStorage, RecipeStorage> reverseRecipes = new HashMap<ItemStorage, RecipeStorage>();

    public void loadRecipes(RecipeManager recipeManager, Level level) {
        this.recipes.clear();
        this.reverseRecipes.clear();
        recipeManager.getAllRecipesFor(RecipeType.SMELTING).forEach(holder -> {
            SmeltingRecipe recipe = (SmeltingRecipe)holder.value();
            NonNullList list = recipe.getIngredients();
            if (list.size() == 1) {
                for (ItemStack smeltable : ((Ingredient)list.get(0)).getItems()) {
                    if (smeltable.isEmpty()) continue;
                    RecipeStorage storage = RecipeStorage.builder().withInputs((List<ItemStorage>)ImmutableList.of((Object)new ItemStorage(smeltable))).withPrimaryOutput(recipe.getResultItem((HolderLookup.Provider)level.registryAccess())).withGridSize(1).withIntermediate(Blocks.FURNACE).withRecipeId(holder.id()).build();
                    this.recipes.put(storage.getCleanedInput().get(0), storage);
                    ItemStack output = recipe.getResultItem((HolderLookup.Provider)level.registryAccess()).copy();
                    output.setCount(1);
                    this.reverseRecipes.put(new ItemStorage(output), storage);
                }
            }
        });
    }

    @Override
    public ItemStack getSmeltingResult(ItemStack itemStack) {
        RecipeStorage storage = this.recipes.getOrDefault(new ItemStorage(itemStack), null);
        if (storage != null) {
            return storage.getPrimaryOutput();
        }
        return ItemStack.EMPTY;
    }

    @Override
    @Nullable
    public RecipeStorage getFirstSmeltingRecipeByResult(ItemStorage storage) {
        return this.reverseRecipes.get(storage);
    }
}

