/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.tileentities;

import com.minecolonies.api.blocks.AbstractBlockMinecoloniesGrave;
import com.minecolonies.api.blocks.types.GraveType;
import com.minecolonies.api.colony.GraveData;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.inventory.container.ContainerGrave;
import com.minecolonies.api.tileentities.AbstractTileEntityGrave;
import com.minecolonies.api.tileentities.AbstractTileEntityRack;
import com.minecolonies.api.tileentities.MinecoloniesTileEntities;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.WorldUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class TileEntityGrave
extends AbstractTileEntityGrave {
    private final Map<ItemStorage, Integer> content = new HashMap<ItemStorage, Integer>();
    private static final String TAG_GRAVE_DATA = "gravedata";

    public TileEntityGrave(BlockEntityType<? extends TileEntityGrave> type, BlockPos pos, BlockState state) {
        super((BlockEntityType<? extends AbstractTileEntityGrave>)type, pos, state);
    }

    public TileEntityGrave(BlockPos pos, BlockState state) {
        super((BlockEntityType<? extends AbstractTileEntityGrave>)((BlockEntityType)MinecoloniesTileEntities.GRAVE.get()), pos, state);
    }

    @Override
    public Map<ItemStorage, Integer> getAllContent() {
        return this.content;
    }

    @Override
    public void updateItemStorage() {
        if (this.level != null && !this.level.isClientSide) {
            boolean empty = this.content.isEmpty();
            this.updateContent();
            if (empty && !this.content.isEmpty() || !empty && this.content.isEmpty()) {
                this.updateBlockState();
            }
            this.setChanged();
        }
    }

    private void updateContent() {
        this.content.clear();
        for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
            ItemStack stack = this.inventory.getStackInSlot(slot);
            if (ItemStackUtils.isEmpty(stack)) continue;
            ItemStorage storage = new ItemStorage(stack.copy());
            int amount = ItemStackUtils.getSize(stack);
            if (this.content.containsKey(storage)) {
                amount += this.content.remove(storage).intValue();
            }
            this.content.put(storage, amount);
        }
    }

    @Override
    public void updateBlockState() {
        if (this.level != null && this.level.getBlockState(this.worldPosition).getBlock() instanceof AbstractBlockMinecoloniesGrave) {
            BlockState state = (BlockState)this.level.getBlockState(this.worldPosition).setValue(AbstractBlockMinecoloniesGrave.VARIANT, (Comparable)((Object)(this.decayed ? GraveType.DECAYED : GraveType.DEFAULT)));
            if (!this.level.getBlockState(this.worldPosition).equals(state)) {
                this.level.setBlockAndUpdate(this.worldPosition, state);
            }
        }
    }

    @Override
    public ItemStackHandler createInventory(int slots) {
        return new AbstractTileEntityRack.RackInventory(slots);
    }

    @Override
    public boolean isEmpty() {
        this.updateContent();
        return this.content.isEmpty();
    }

    @Override
    public void loadAdditional(CompoundTag compound, @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        this.decay_timer = compound.contains("decaytimer") ? compound.getInt("decaytimer") : 6000;
        boolean bl = this.decayed = compound.contains("decayed") ? compound.getBoolean("decayed") : false;
        if (compound.contains(TAG_GRAVE_DATA)) {
            this.graveData = new GraveData();
            this.graveData.read(compound.getCompound(TAG_GRAVE_DATA));
        } else {
            this.graveData = null;
        }
    }

    @Override
    public void saveAdditional(CompoundTag compound, @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        compound.putInt("decaytimer", this.decay_timer);
        compound.putBoolean("decayed", this.decayed);
        if (this.graveData != null) {
            compound.put(TAG_GRAVE_DATA, (Tag)this.graveData.write());
        }
    }

    @Override
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @Override
    @NotNull
    public CompoundTag getUpdateTag(@NotNull HolderLookup.Provider provider) {
        return this.saveWithId(provider);
    }

    @Override
    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet, @NotNull HolderLookup.Provider provider) {
        this.loadAdditional(packet.getTag(), provider);
    }

    @Override
    public void handleUpdateTag(CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        this.loadAdditional(tag, provider);
    }

    @Override
    public void setChanged() {
        if (this.level != null) {
            WorldUtil.markChunkDirty(this.level, this.worldPosition);
        }
    }

    @Override
    @Nullable
    public AbstractContainerMenu createMenu(int id, @NotNull Inventory inv, @NotNull Player player) {
        RegistryFriendlyByteBuf buffer = new RegistryFriendlyByteBuf((ByteBuf)new FriendlyByteBuf(Unpooled.buffer()), player.level().registryAccess());
        buffer.writeBlockPos(this.getBlockPos());
        return new ContainerGrave(id, inv, buffer);
    }

    @Override
    @NotNull
    public Component getDisplayName() {
        return Component.literal((String)"Grave");
    }

    public boolean onColonyTick(double delay) {
        if (this.hasLevel() && !this.level.isClientSide && this.decay_timer != -1) {
            this.decay_timer = (int)((double)this.decay_timer - delay);
            if (this.decay_timer <= 0) {
                if (!this.decayed) {
                    this.decayed = true;
                    this.decay_timer = 6000;
                    this.updateBlockState();
                } else {
                    InventoryUtils.dropItemHandler((IItemHandler)this.inventory, this.level, this.worldPosition.getX(), this.worldPosition.getY(), this.worldPosition.getZ());
                    this.level.setBlockAndUpdate(this.worldPosition, Blocks.AIR.defaultBlockState());
                    return false;
                }
            }
        }
        return true;
    }
}

