/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server.colony;

import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.core.network.messages.server.AbstractColonyServerMessage;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class WorkOrderChangeMessage
extends AbstractColonyServerMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"minecolonies", (String)"work_order_change", WorkOrderChangeMessage::new);
    private final int workOrderId;
    private final int priority;
    private final boolean removeWorkOrder;

    public WorkOrderChangeMessage(@NotNull IBuildingView building, int workOrderId, boolean removeWorkOrder, int priority) {
        super(TYPE, building.getColony());
        this.workOrderId = workOrderId;
        this.removeWorkOrder = removeWorkOrder;
        this.priority = priority;
    }

    protected WorkOrderChangeMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.workOrderId = buf.readInt();
        this.priority = buf.readInt();
        this.removeWorkOrder = buf.readBoolean();
    }

    @Override
    protected void toBytes(@NotNull RegistryFriendlyByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.workOrderId);
        buf.writeInt(this.priority);
        buf.writeBoolean(this.removeWorkOrder);
    }

    @Override
    protected void onExecute(IPayloadContext ctxIn, ServerPlayer player, IColony colony) {
        if (this.removeWorkOrder) {
            colony.getWorkManager().removeWorkOrder(this.workOrderId);
        } else if (colony.getWorkManager().getWorkOrder(this.workOrderId) != null) {
            colony.getWorkManager().getWorkOrder(this.workOrderId).setPriority(this.priority);
        }
    }
}

