/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server.colony;

import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.core.network.messages.server.AbstractColonyServerMessage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeFreeToInteractBlockMessage
extends AbstractColonyServerMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"minecolonies", (String)"change_free_to_interact_block", ChangeFreeToInteractBlockMessage::new);
    private final BlockPos pos;
    private final BlockState block;
    private final MessageType msgType;
    private final MessageMode msgMode;

    public ChangeFreeToInteractBlockMessage(@NotNull IColonyView colony, @NotNull Block block, @NotNull MessageType type) {
        super(TYPE, colony);
        this.pos = new BlockPos(0, 0, 0);
        this.block = block.defaultBlockState();
        this.msgType = type;
        this.msgMode = MessageMode.BLOCK;
    }

    public ChangeFreeToInteractBlockMessage(@NotNull IColonyView colony, @NotNull BlockPos pos, @NotNull MessageType type) {
        super(TYPE, colony);
        this.pos = pos;
        this.block = Blocks.DIRT.defaultBlockState();
        this.msgType = type;
        this.msgMode = MessageMode.LOCATION;
    }

    protected ChangeFreeToInteractBlockMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.block = Block.stateById((int)buf.readInt());
        this.pos = buf.readBlockPos();
        this.msgType = MessageType.values()[buf.readInt()];
        this.msgMode = MessageMode.values()[buf.readInt()];
    }

    @Override
    protected void toBytes(@NotNull RegistryFriendlyByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(Block.getId((BlockState)this.block));
        buf.writeBlockPos(this.pos);
        buf.writeInt(this.msgType.ordinal());
        buf.writeInt(this.msgMode.ordinal());
    }

    @Override
    @Nullable
    protected Action permissionNeeded() {
        return Action.EDIT_PERMISSIONS;
    }

    @Override
    protected void onExecute(IPayloadContext ctxIn, ServerPlayer player, IColony colony) {
        if (player == null) {
            return;
        }
        if (this.msgType == MessageType.ADD_BLOCK) {
            switch (this.msgMode.ordinal()) {
                case 0: {
                    colony.addFreePosition(this.pos);
                    MessageUtils.format("com.minecolonies.coremod.item.permissionscepter.addposition.success", this.pos.getX(), this.pos.getY(), this.pos.getZ()).sendTo(new Player[]{player});
                    break;
                }
                case 1: {
                    colony.addFreeBlock(this.block.getBlock());
                    MessageUtils.format("com.minecolonies.coremod.item.permissionscepter.addblock.success", BuiltInRegistries.BLOCK.getKey((Object)this.block.getBlock())).sendTo(new Player[]{player});
                    break;
                }
            }
        } else {
            switch (this.msgMode.ordinal()) {
                case 0: {
                    colony.removeFreePosition(this.pos);
                    MessageUtils.format("com.minecolonies.coremod.item.permissionscepter.removelocation.success", this.pos.getX(), this.pos.getY(), this.pos.getZ()).sendTo(new Player[]{player});
                    break;
                }
                case 1: {
                    colony.removeFreeBlock(this.block.getBlock());
                    MessageUtils.format("com.minecolonies.coremod.item.permissionscepter.removeblock.success", BuiltInRegistries.BLOCK.getKey((Object)this.block.getBlock())).sendTo(new Player[]{player});
                    break;
                }
            }
        }
    }

    public static enum MessageType {
        REMOVE_BLOCK,
        ADD_BLOCK;

    }

    public static enum MessageMode {
        LOCATION,
        BLOCK;

    }
}

