/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server;

import com.ldtteam.common.network.AbstractServerPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.core.colony.Colony;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class PickupBlockMessage
extends AbstractServerPlayMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"minecolonies", (String)"pickup_block", PickupBlockMessage::new);
    BlockPos pos;

    public PickupBlockMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(type);
        this.pos = buf.readBlockPos();
    }

    public PickupBlockMessage(BlockPos pos) {
        super(TYPE);
        this.pos = pos;
    }

    public void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
    }

    protected void onExecute(IPayloadContext ctxIn, ServerPlayer sender) {
        if (sender == null) {
            return;
        }
        Level world = sender.level();
        if (IColonyManager.getInstance().getColonyByPosFromWorld(world, this.pos) instanceof Colony) {
            return;
        }
        ItemStack stack = new ItemStack((ItemLike)world.getBlockState(this.pos).getBlock(), 1);
        if (InventoryUtils.addItemStackToItemHandler((IItemHandler)new InvWrapper((Container)sender.getInventory()), stack)) {
            world.destroyBlock(this.pos, false);
        } else {
            MessageUtils.format("com.minecolonies.coremod.playerinvfull", new Object[0]).sendTo(new Player[]{sender});
        }
    }
}

