/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.client.colony;

import com.ldtteam.common.network.AbstractClientPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.colony.IColonyManager;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ColonyViewRemoveMessage
extends AbstractClientPlayMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forClient((String)"minecolonies", (String)"colony_view_remove", ColonyViewRemoveMessage::new);
    private final int id;
    private final ResourceKey<Level> dimension;

    public ColonyViewRemoveMessage(int id, ResourceKey<Level> dimension) {
        super(TYPE);
        this.id = id;
        this.dimension = dimension;
    }

    protected void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.id);
        buf.writeUtf(this.dimension.location().toString());
    }

    protected ColonyViewRemoveMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.id = buf.readInt();
        this.dimension = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)buf.readUtf(Short.MAX_VALUE)));
    }

    protected void onExecute(IPayloadContext ctxIn, Player player) {
        IColonyManager.getInstance().removeColonyView(this.id, this.dimension);
    }
}

