/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.client;

import com.ldtteam.common.network.AbstractClientPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class StreamParticleEffectMessage
extends AbstractClientPlayMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forClient((String)"minecolonies", (String)"stream_particle_effect", StreamParticleEffectMessage::new);
    private static final Random RAND = new Random();
    private final SimpleParticleType type;
    private final double sPosX;
    private final double sPosY;
    private final double sPosZ;
    private final double ePosX;
    private final double ePosY;
    private final double ePosZ;
    private final int stage;
    private final int maxStage;

    public StreamParticleEffectMessage(Vec3 start, Vec3 end, SimpleParticleType type, int stage, int maxStage) {
        super(TYPE);
        this.sPosX = start.x;
        this.sPosY = start.y - 0.5;
        this.sPosZ = start.z;
        this.ePosX = end.x;
        this.ePosY = end.y - 0.5;
        this.ePosZ = end.z;
        this.stage = stage;
        this.maxStage = maxStage;
        this.type = type;
    }

    protected StreamParticleEffectMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.sPosX = buf.readDouble();
        this.sPosY = buf.readDouble();
        this.sPosZ = buf.readDouble();
        this.ePosX = buf.readDouble();
        this.ePosY = buf.readDouble();
        this.ePosZ = buf.readDouble();
        this.stage = buf.readInt();
        this.maxStage = buf.readInt();
        this.type = (SimpleParticleType)BuiltInRegistries.PARTICLE_TYPE.get(buf.readResourceLocation());
    }

    protected void toBytes(@NotNull RegistryFriendlyByteBuf buf) {
        buf.writeDouble(this.sPosX);
        buf.writeDouble(this.sPosY);
        buf.writeDouble(this.sPosZ);
        buf.writeDouble(this.ePosX);
        buf.writeDouble(this.ePosY);
        buf.writeDouble(this.ePosZ);
        buf.writeInt(this.stage);
        buf.writeInt(this.maxStage);
        buf.writeResourceLocation(BuiltInRegistries.PARTICLE_TYPE.getKey((Object)this.type));
    }

    protected void onExecute(IPayloadContext ctxIn, Player player) {
        Vec3 end = new Vec3(this.ePosX, this.ePosY, this.ePosZ);
        double xDif = (this.sPosX - this.ePosX) / (double)this.maxStage;
        double yDif = (this.sPosY - this.ePosY) / (double)this.maxStage;
        double zDif = (this.sPosZ - this.ePosZ) / (double)this.maxStage;
        double curve = (double)this.maxStage / 3.0;
        for (int step = Math.max(0, this.stage - 1); step <= Math.min(this.maxStage, this.stage + 1); ++step) {
            double minDif = (double)Math.min(step, Math.abs(step - this.maxStage)) / curve;
            for (int i = 0; i < 10; ++i) {
                Vec3 randomPos = new Vec3(RAND.nextDouble() * 0.1 + 0.1, RAND.nextDouble() * 0.1 + 0.1, RAND.nextDouble() * 0.1 + 0.1);
                Vec3 randomOffset = new Vec3((RAND.nextDouble() - 0.5) * 0.1, (RAND.nextDouble() - 0.5) * 0.1, (RAND.nextDouble() - 0.5) * 0.1);
                player.level().addParticle((ParticleOptions)this.type, end.x + randomOffset.x + xDif * (double)step, end.y + randomOffset.y + yDif * (double)step + minDif, end.z + randomOffset.z + zDif * (double)step, randomPos.x, randomPos.y + 0.05, randomPos.z);
            }
        }
    }
}

