/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.client;

import com.ldtteam.common.network.AbstractClientPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class CompostParticleMessage
extends AbstractClientPlayMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forClient((String)"minecolonies", (String)"compost_particle", CompostParticleMessage::new);
    public static final Random random = new Random();
    private final BlockPos pos;

    public CompostParticleMessage(BlockPos pos) {
        super(TYPE);
        this.pos = pos;
    }

    public CompostParticleMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.pos = buf.readBlockPos();
    }

    protected void toBytes(@NotNull RegistryFriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
    }

    protected void onExecute(IPayloadContext ctxIn, Player player) {
        Level world = player.level();
        int amount = random.nextInt(15) + 1;
        BlockState state = world.getBlockState(this.pos);
        if (!state.isAir()) {
            for (int i = 0; i < amount; ++i) {
                double d0 = random.nextGaussian() * 0.02;
                double d1 = random.nextGaussian() * 0.02;
                double d2 = random.nextGaussian() * 0.02;
                world.addParticle((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, (double)((float)this.pos.getX() + random.nextFloat()), (double)this.pos.getY() + (double)random.nextFloat() * state.getShape((BlockGetter)world, (BlockPos)this.pos).bounds().maxY, (double)((float)this.pos.getZ() + random.nextFloat()), d0, d1, d2);
            }
        } else {
            for (int i = 0; i < amount; ++i) {
                double d0 = random.nextGaussian() * 0.02;
                double d1 = random.nextGaussian() * 0.02;
                double d2 = random.nextGaussian() * 0.02;
                world.addParticle((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, (double)((float)this.pos.getX() + random.nextFloat()), (double)this.pos.getY() + (double)random.nextFloat() * 1.0, (double)((float)this.pos.getZ() + random.nextFloat()), d0, d1, d2);
            }
        }
    }
}

