/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.items;

import com.ldtteam.structurize.blocks.ModBlocks;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.blueprints.v1.BlueprintTagUtils;
import com.ldtteam.structurize.placement.handlers.placement.PlacementError;
import com.ldtteam.structurize.util.BlockUtils;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.configuration.ServerConfiguration;
import com.minecolonies.api.items.ISupplyItem;
import com.minecolonies.api.items.component.SupplyData;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.core.MineColonies;
import com.minecolonies.core.client.gui.WindowSupplies;
import com.minecolonies.core.client.gui.WindowSupplyStory;
import com.minecolonies.core.entity.pathfinding.PathfindingUtils;
import com.minecolonies.core.items.AbstractItemMinecolonies;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemSupplyChestDeployer
extends AbstractItemMinecolonies
implements ISupplyItem {
    private static final String SUPPLY_SHIP_STRUCTURE_NAME = "supplyship";
    private static final String SUPPLY_SHIP_STRUCTURE_NAME_NETHER = "nethership";
    private static final int SCAN_HEIGHT = 7;
    private static final int DEFAULT_WATER_LEVELS = 3;

    public ItemSupplyChestDeployer(Item.Properties properties) {
        super("supplychestdeployer", properties.stacksTo(1));
    }

    @NotNull
    public InteractionResult useOn(UseOnContext ctx) {
        SupplyData currentComponent = SupplyData.readFromItemStack(ctx.getItemInHand());
        if (!currentComponent.hasRandomKey()) {
            currentComponent.withRandomKey(ctx.getClickedPos().asLong()).writeToItemStack(ctx.getItemInHand());
        }
        if (ctx.getLevel().isClientSide) {
            if (!((Boolean)((ServerConfiguration)MineColonies.getConfig().getServer()).allowOtherDimColonies.get()).booleanValue() && !WorldUtil.isOverworldType(ctx.getLevel())) {
                return InteractionResult.FAIL;
            }
            this.placeSupplyShip(ctx.getLevel(), ctx.getClickedPos().relative(ctx.getHorizontalDirection(), 10).above(), ctx.getHand(), ctx.getItemInHand());
        }
        return InteractionResult.FAIL;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand hand) {
        ItemStack stack = playerIn.getItemInHand(hand);
        SupplyData currentComponent = SupplyData.readFromItemStack(stack);
        if (currentComponent.hasRandomKey()) {
            currentComponent.withRandomKey(playerIn.blockPosition().asLong()).writeToItemStack(stack);
        }
        if (worldIn.isClientSide) {
            if (!((Boolean)((ServerConfiguration)MineColonies.getConfig().getServer()).allowOtherDimColonies.get()).booleanValue() && !WorldUtil.isOverworldType(worldIn)) {
                MessageUtils.format("com.minecolonies.coremod.dimension.no", new Object[0]).sendTo(playerIn);
                return new InteractionResultHolder(InteractionResult.FAIL, (Object)stack);
            }
            this.placeSupplyShip(worldIn, null, hand, stack);
        }
        return new InteractionResultHolder(InteractionResult.FAIL, (Object)stack);
    }

    private void placeSupplyShip(Level world, @Nullable BlockPos pos, InteractionHand hand, ItemStack itemInHand) {
        String name = WorldUtil.isNetherType(world) ? SUPPLY_SHIP_STRUCTURE_NAME_NETHER : SUPPLY_SHIP_STRUCTURE_NAME;
        SupplyData currentComponent = SupplyData.readFromItemStack(itemInHand);
        if (!currentComponent.sawStory()) {
            new WindowSupplyStory(pos, name, itemInHand, hand).open();
            return;
        }
        if (pos == null) {
            new WindowSupplies(pos, name).open();
            return;
        }
        new WindowSupplies(pos, name).open();
    }

    public static boolean canShipBePlaced(@NotNull Level world, @NotNull BlockPos pos, Blueprint ship, @NotNull List<PlacementError> placementErrorList, Player placer) {
        if (((Boolean)((ServerConfiguration)MineColonies.getConfig().getServer()).noSupplyPlacementRestrictions.get()).booleanValue()) {
            return true;
        }
        int sizeX = ship.getSizeX();
        int sizeZ = ship.getSizeZ();
        int waterLevel = BlueprintTagUtils.getNumberOfGroundLevels((Blueprint)ship, (int)3);
        BlockPos zeroPos = pos.subtract((Vec3i)ship.getPrimaryBlockOffset());
        ArrayList<PlacementError> needsAirAbove = new ArrayList<PlacementError>();
        ArrayList<PlacementError> needsWaterList = new ArrayList<PlacementError>();
        for (int z = 0; z < sizeZ; ++z) {
            for (int x = 0; x < sizeX; ++x) {
                for (int y = 0; y <= Math.min(waterLevel + 7, ship.getSizeY() - 1); ++y) {
                    BlockPos worldPos = new BlockPos(zeroPos.getX() + x, zeroPos.getY() + y, zeroPos.getZ() + z);
                    BlockState state = ship.getBlockState(new BlockPos(x, y, z));
                    if (y < waterLevel) {
                        ItemSupplyChestDeployer.checkFluidAndNotInColony(world, worldPos, needsWaterList, placer, state);
                        continue;
                    }
                    if (!BlockUtils.isAnySolid((BlockState)world.getBlockState(worldPos)) || state.getBlock() == ModBlocks.blockSubstitution.get()) continue;
                    needsAirAbove.add(new PlacementError(PlacementError.PlacementErrorType.NEEDS_AIR_ABOVE, worldPos));
                }
            }
        }
        if ((double)needsAirAbove.size() > (double)(sizeX * sizeZ) * 0.3333333333333333 || (double)needsWaterList.size() > (double)(sizeX * sizeZ) * 0.3333333333333333) {
            placementErrorList.addAll(needsAirAbove);
            placementErrorList.addAll(needsWaterList);
            return false;
        }
        return true;
    }

    private static void checkFluidAndNotInColony(Level world, BlockPos pos, @NotNull List<PlacementError> placementErrorList, Player placer, BlockState state) {
        boolean isOverworld = WorldUtil.isOverworldType(world);
        boolean isWater = PathfindingUtils.isWater((BlockGetter)world, pos);
        boolean notInAnyColony = ItemSupplyChestDeployer.hasPlacePermission(world, pos, placer);
        if (state.getBlock() != ModBlocks.blockFluidSubstitution.get()) {
            if (!isWater && isOverworld) {
                placementErrorList.add(new PlacementError(PlacementError.PlacementErrorType.NOT_WATER, pos));
            } else if (!world.getBlockState(pos).getFluidState().getType().isSame((Fluid)Fluids.LAVA) && !isOverworld) {
                placementErrorList.add(new PlacementError(PlacementError.PlacementErrorType.NOT_WATER, pos));
            }
        }
        if (!notInAnyColony) {
            placementErrorList.add(new PlacementError(PlacementError.PlacementErrorType.INSIDE_COLONY, pos));
        }
    }

    private static boolean hasPlacePermission(Level world, BlockPos pos, Player placer) {
        IColony colony = IColonyManager.getInstance().getColonyByPosFromWorld(world, pos);
        return colony == null || colony.getPermissions().hasPermission(placer, Action.PLACE_BLOCKS);
    }
}

