/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.generation.defaults;

import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.core.blocks.MinecoloniesCropBlock;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.data.DataMapProvider;
import net.neoforged.neoforge.registries.datamaps.builtin.Compostable;
import net.neoforged.neoforge.registries.datamaps.builtin.NeoForgeDataMaps;
import org.jetbrains.annotations.NotNull;

public class DefaultDataMapsProvider
extends DataMapProvider {
    public DefaultDataMapsProvider(@NotNull PackOutput packOutput, @NotNull CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(packOutput, lookupProvider);
    }

    protected void gather() {
        this.generateCompostables();
    }

    private void generateCompostables() {
        DataMapProvider.Builder builder = this.builder(NeoForgeDataMaps.COMPOSTABLES);
        DefaultDataMapsProvider.registerCompostItemFromNutrition((DataMapProvider.Builder<Compostable, Item>)builder, ModItems.milkyBread.asItem(), 6.0f);
        DefaultDataMapsProvider.registerCompostItemFromNutrition((DataMapProvider.Builder<Compostable, Item>)builder, ModItems.sugaryBread.asItem(), 6.0f);
        DefaultDataMapsProvider.registerCompostItemFromNutrition((DataMapProvider.Builder<Compostable, Item>)builder, ModItems.goldenBread.asItem(), 6.0f);
        DefaultDataMapsProvider.registerCompostItemFromNutrition((DataMapProvider.Builder<Compostable, Item>)builder, ModItems.chorusBread.asItem(), 6.0f);
        for (Item item : ModItems.getAllIngredients()) {
            DefaultDataMapsProvider.registerCompostItemFromNutrition((DataMapProvider.Builder<Compostable, Item>)builder, item, 10.0f);
        }
        for (Item item : ModItems.getAllFoods()) {
            DefaultDataMapsProvider.registerCompostItemFromNutrition((DataMapProvider.Builder<Compostable, Item>)builder, item, 6.0f);
        }
        builder.add((Holder)ModItems.mistletoe.builtInRegistryHolder(), (Object)new Compostable(0.5f), false, new ICondition[0]);
        for (MinecoloniesCropBlock minecoloniesCropBlock : ModBlocks.getCrops()) {
            builder.add((Holder)minecoloniesCropBlock.asItem().builtInRegistryHolder(), (Object)new Compostable(0.5f), false, new ICondition[0]);
        }
        builder.add((Holder)ModBlocks.blockCompostedDirt.asItem().builtInRegistryHolder(), (Object)new Compostable(1.0f), false, new ICondition[0]);
    }

    private static void registerCompostItemFromNutrition(DataMapProvider.Builder<Compostable, Item> builder, Item item, float factor) {
        float strength;
        FoodProperties food = item.getFoodProperties(new ItemStack((ItemLike)item), null);
        if (food != null && (strength = Math.min(1.0f, (float)food.nutrition() / factor)) > 0.0f) {
            builder.add((Holder)item.builtInRegistryHolder(), (Object)new Compostable(strength), false, new ICondition[0]);
        }
    }
}

