/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.pathfinding.registry;

import com.google.common.collect.Maps;
import com.minecolonies.api.entity.pathfinding.registry.IPathNavigateRegistry;
import com.minecolonies.core.entity.pathfinding.navigation.AbstractAdvancedPathNavigate;
import com.minecolonies.core.entity.pathfinding.navigation.MinecoloniesAdvancedPathNavigate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.world.entity.Mob;

public class PathNavigateRegistry
implements IPathNavigateRegistry {
    private static final Function<Mob, AbstractAdvancedPathNavigate> DEFAULT = entityLiving -> new MinecoloniesAdvancedPathNavigate((Mob)entityLiving, entityLiving.level());
    private final Map<Predicate<Mob>, Function<Mob, AbstractAdvancedPathNavigate>> registry = Maps.newLinkedHashMap();

    @Override
    public IPathNavigateRegistry registerNewPathNavigate(Predicate<Mob> selectionPredicate, Function<Mob, AbstractAdvancedPathNavigate> navigateProducer) {
        this.registry.put(selectionPredicate, navigateProducer);
        return this;
    }

    @Override
    public AbstractAdvancedPathNavigate getNavigateFor(Mob entityLiving) {
        ArrayList<Predicate<Mob>> predicates = new ArrayList<Predicate<Mob>>(this.registry.keySet());
        Collections.reverse(predicates);
        return predicates.stream().filter(predicate -> predicate.test(entityLiving)).findFirst().map(predicate -> this.registry.get(predicate)).orElse(DEFAULT).apply(entityLiving);
    }
}

