/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.pathfinding.pathjobs;

import com.ldtteam.structurize.util.BlockUtils;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.Pond;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.core.entity.pathfinding.MNode;
import com.minecolonies.core.entity.pathfinding.PathfindingUtils;
import com.minecolonies.core.entity.pathfinding.PathingOptions;
import com.minecolonies.core.entity.pathfinding.SurfaceType;
import com.minecolonies.core.entity.pathfinding.pathjobs.AbstractPathJob;
import com.minecolonies.core.entity.pathfinding.pathjobs.ISearchPathJob;
import com.minecolonies.core.entity.pathfinding.pathresults.PathResult;
import com.minecolonies.core.entity.pathfinding.pathresults.WaterPathResult;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import org.jetbrains.annotations.NotNull;

public class PathJobFindWater
extends AbstractPathJob
implements ISearchPathJob {
    private static final int MAX_RANGE = 100;
    private final BlockPos hutLocation;
    @NotNull
    private final List<Tuple<BlockPos, BlockPos>> ponds;

    public PathJobFindWater(Level world, @NotNull BlockPos start, BlockPos home, int range, @NotNull List<Tuple<BlockPos, BlockPos>> ponds, Mob entity) {
        super(world, start, range, (PathResult)new WaterPathResult(), entity);
        this.ponds = new ArrayList<Tuple<BlockPos, BlockPos>>(ponds);
        this.hutLocation = home;
    }

    @Override
    @NotNull
    public WaterPathResult getResult() {
        return (WaterPathResult)super.getResult();
    }

    @Override
    protected double computeHeuristic(int x, int y, int z) {
        return BlockPosUtil.distManhattan(this.hutLocation, x, y, z);
    }

    @Override
    protected boolean isAtDestination(@NotNull MNode n) {
        if (BlockPosUtil.distSqr(this.hutLocation, n.x, n.y, n.z) > 10000) {
            return false;
        }
        BlockPos.MutableBlockPos problemPos = this.debugDrawEnabled ? BlockPosUtil.SAFE_ZERO.mutable() : null;
        Pond.PondState pondState = Pond.checkPond((BlockGetter)this.world, (BlockPos)this.tempWorldPos.set(n.x, n.y - 1, n.z), problemPos);
        if (n.isSwimming() && pondState != Pond.PondState.INVALID) {
            for (Tuple<BlockPos, BlockPos> existingPond : this.ponds) {
                if (BlockPosUtil.distManhattan(existingPond.getA(), n.x, n.y, n.z) >= 7) continue;
                return false;
            }
            PathJobFindFishingPos job = new PathJobFindFishingPos(this.getActualWorld(), this.world, new BlockPos(n.x, n.y, n.z), this.hutLocation, 10);
            job.setPathingOptions(this.getPathingOptions());
            Path path = job.search();
            if (path != null && path.canReach()) {
                this.getResult().pond = new BlockPos(n.x, n.y, n.z);
                this.getResult().pondState = pondState;
                this.getResult().parent = path.getTarget();
                return true;
            }
        }
        if (problemPos != null && !problemPos.equals((Object)BlockPosUtil.SAFE_ZERO)) {
            this.debugNodesExtra.add(new MNode(n, problemPos.getX(), problemPos.getY(), problemPos.getZ(), -1.0, -1.0));
        }
        return false;
    }

    @Override
    protected double modifyCost(double cost, MNode parent, boolean swimstart, boolean swimming, int x, int y, int z, BlockState state, BlockState below) {
        if (BlockPosUtil.distSqr(this.hutLocation, x, y, z) > 10000) {
            return cost * 10.0;
        }
        return cost;
    }

    @Override
    public void setPathingOptions(PathingOptions pathingOptions) {
        super.setPathingOptions(pathingOptions);
        this.getPathingOptions().swimCostEnter = 0.0;
        this.getPathingOptions().swimCost = 0.0;
    }

    @Override
    public double getEndNodeScore(MNode n) {
        return BlockPosUtil.distManhattan(this.hutLocation, n.x, n.y, n.z);
    }

    private class PathJobFindFishingPos
    extends AbstractPathJob
    implements ISearchPathJob {
        private final BlockPos direction;
        private final int distance;

        public PathJobFindFishingPos(Level actualWorld, @NotNull LevelReader world, @NotNull BlockPos start, BlockPos direction, int distance) {
            super(actualWorld, world, start, distance + 100, new PathResult(), null);
            this.direction = direction;
            this.distance = distance;
        }

        @Override
        protected void handleDebugOptions(MNode node) {
            PathJobFindWater.this.handleDebugOptions(node);
        }

        @Override
        protected double computeHeuristic(int x, int y, int z) {
            return BlockPosUtil.distManhattan(this.direction, x, y, z);
        }

        @Override
        protected boolean isAtDestination(MNode n) {
            return !n.isSwimming() && BlockPosUtil.distManhattan(this.start, n.x, n.y, n.z) < this.distance && SurfaceType.getSurfaceType((BlockGetter)this.world, this.cachedBlockLookup.getBlockState(n.x, n.y - 1, n.z), (BlockPos)this.tempWorldPos.set(n.x, n.y - 1, n.z), this.getPathingOptions()) == SurfaceType.WALKABLE && BlockUtils.isAnySolid((BlockState)this.cachedBlockLookup.getBlockState(n.x, n.y - 1, n.z)) && this.canSeeTargetFromPos(n);
        }

        private boolean canSeeTargetFromPos(MNode n) {
            return !PathfindingUtils.hasAnyCollisionAlong(this.start.getX(), this.start.getY(), this.start.getZ(), n.x, n.y + 1, n.z, this.cachedBlockLookup);
        }

        @Override
        public double getEndNodeScore(MNode n) {
            return BlockPosUtil.distManhattan(this.start, n.x, n.y, n.z);
        }
    }
}

