/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.pathfinding.pathjobs;

import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.core.entity.pathfinding.MNode;
import com.minecolonies.core.entity.pathfinding.PathfindingUtils;
import com.minecolonies.core.entity.pathfinding.SurfaceType;
import com.minecolonies.core.entity.pathfinding.pathjobs.AbstractPathJob;
import com.minecolonies.core.entity.pathfinding.pathjobs.ISearchPathJob;
import com.minecolonies.core.entity.pathfinding.pathresults.PathResult;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class PathJobCanSee
extends AbstractPathJob
implements ISearchPathJob {
    private final LivingEntity lookTarget;
    private final BlockPos searchAroundPos;

    public PathJobCanSee(Mob searchingEntity, LivingEntity lookTarget, Level world, @NotNull BlockPos searchAroundPos, int range) {
        super(world, PathfindingUtils.prepareStart((LivingEntity)searchingEntity), range, new PathResult(), searchingEntity);
        this.searchAroundPos = searchAroundPos;
        this.lookTarget = lookTarget;
    }

    @Override
    protected double computeHeuristic(int x, int y, int z) {
        return BlockPosUtil.distManhattan(this.searchAroundPos.getX(), this.searchAroundPos.getY(), this.searchAroundPos.getZ(), x, y, z);
    }

    @Override
    protected boolean isAtDestination(MNode n) {
        if (this.searchAroundPos.getY() - n.y > 2) {
            return false;
        }
        return this.canSeeTargetFromPos((BlockPos)this.tempWorldPos.set(n.x, n.y, n.z)) && SurfaceType.getSurfaceType((BlockGetter)this.world, this.cachedBlockLookup.getBlockState(n.x, n.y - 1, n.z), (BlockPos)this.tempWorldPos.set(n.x, n.y - 1, n.z), this.getPathingOptions()) == SurfaceType.WALKABLE;
    }

    @Override
    public double getEndNodeScore(@NotNull MNode n) {
        return BlockPosUtil.distManhattan(this.start, n.x, n.y, n.z);
    }

    private boolean canSeeTargetFromPos(BlockPos pos) {
        Vec3 vec3d1;
        Vec3 vec3d = new Vec3((double)pos.getX(), (double)((float)pos.getY() + this.entity.getEyeHeight()), (double)pos.getZ());
        return this.world.clip(new ClipContext(vec3d, vec3d1 = new Vec3(this.lookTarget.getX(), this.lookTarget.getEyeY(), this.lookTarget.getZ()), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.entity)).getType() == HitResult.Type.MISS;
    }
}

