/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.citizen.citizenhandlers;

import com.minecolonies.api.advancements.AdvancementTriggers;
import com.minecolonies.api.advancements.ArmyPopulationTrigger;
import com.minecolonies.api.client.render.modeltype.ModModelTypes;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.entity.ai.ITickingStateAI;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenJobHandler;
import com.minecolonies.core.colony.jobs.AbstractJobGuard;
import com.minecolonies.core.util.AdvancementUtils;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CitizenJobHandler
implements ICitizenJobHandler {
    private final AbstractEntityCitizen citizen;
    private ITickingStateAI workAI = null;

    public CitizenJobHandler(AbstractEntityCitizen citizen) {
        this.citizen = citizen;
    }

    @Override
    public void setModelDependingOnJob(@Nullable IJob<?> job) {
        if (this.citizen.isBaby()) {
            this.citizen.setModelId(ModModelTypes.CHILD_ID);
            this.citizen.getEntityData().set(AbstractEntityCitizen.DATA_MODEL, (Object)this.citizen.getModelType().toString());
            this.citizen.setRenderMetadata("");
            return;
        }
        if (job == null) {
            if (this.citizen.getCitizenColonyHandler().getHomeBuilding() != null) {
                switch (this.citizen.getCitizenColonyHandler().getHomeBuilding().getBuildingLevelEquivalent()) {
                    case 3: {
                        this.citizen.setModelId(ModModelTypes.CITIZEN_ID);
                        break;
                    }
                    case 4: {
                        this.citizen.setModelId(ModModelTypes.NOBLE_ID);
                        break;
                    }
                    case 5: {
                        this.citizen.setModelId(ModModelTypes.ARISTOCRAT_ID);
                        break;
                    }
                    default: {
                        this.citizen.setModelId(ModModelTypes.SETTLER_ID);
                        break;
                    }
                }
            } else {
                this.citizen.setModelId(ModModelTypes.SETTLER_ID);
            }
        } else {
            this.citizen.setModelId(job.getModel());
        }
        this.citizen.getEntityData().set(AbstractEntityCitizen.DATA_MODEL, (Object)this.citizen.getModelType().toString());
        this.citizen.setRenderMetadata("");
    }

    @Override
    public void onJobChanged(@Nullable IJob<?> job) {
        this.setModelDependingOnJob(job);
        if (job != null) {
            job.createAI();
            if (job instanceof AbstractJobGuard) {
                IColony colony = this.citizen.getCitizenColonyHandler().getColonyOrRegister();
                int guards = (int)colony.getCitizenManager().getCitizens().stream().filter(citizen -> citizen.getJob() instanceof AbstractJobGuard).count();
                AdvancementUtils.TriggerAdvancementPlayersForColony(this.citizen.getCitizenColonyHandler().getColony(), player -> ((ArmyPopulationTrigger)((Object)((Object)AdvancementTriggers.ARMY_POPULATION.get()))).trigger((ServerPlayer)player, guards));
            }
            job.initEntityValues(this.citizen);
        }
    }

    @Override
    @Nullable
    public <J extends IJob<?>> J getColonyJob(@NotNull Class<J> type) {
        return this.citizen.getCitizenData() == null ? null : (J)this.citizen.getCitizenData().getJob(type);
    }

    @Override
    @Nullable
    public IJob<?> getColonyJob() {
        return this.citizen.getCitizenData() == null ? null : this.citizen.getCitizenData().getJob();
    }

    @Override
    public boolean shouldRunAvoidance() {
        return this.getColonyJob() == null || this.getColonyJob().allowsAvoidance();
    }

    @Override
    public void setWorkAI(ITickingStateAI workAI) {
        this.workAI = workAI;
    }

    @Override
    public ITickingStateAI getWorkAI() {
        return this.workAI;
    }
}

